/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.htmlunit.cssparser.dom.CounterImpl;
import org.htmlunit.cssparser.dom.DOMExceptionImpl;
import org.htmlunit.cssparser.dom.HSLColorImpl;
import org.htmlunit.cssparser.dom.HWBColorImpl;
import org.htmlunit.cssparser.dom.LABColorImpl;
import org.htmlunit.cssparser.dom.LCHColorImpl;
import org.htmlunit.cssparser.dom.RGBColorImpl;
import org.htmlunit.cssparser.dom.RectImpl;
import org.htmlunit.cssparser.parser.AbstractLocatable;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.htmlunit.cssparser.parser.LexicalUnitImpl;
import org.htmlunit.cssparser.util.ParserUtils;
import org.w3c.dom.DOMException;

public class CSSValueImpl
extends AbstractLocatable
implements Serializable {
    private Object value_;

    public Object getValue() {
        return this.value_;
    }

    public CSSValueImpl(LexicalUnit value, boolean forcePrimitive) {
        LexicalUnit parameters = null;
        if (value != null) {
            parameters = value.getParameters();
        }
        this.value_ = !forcePrimitive && value != null && value.getNextLexicalUnit() != null ? CSSValueImpl.getValues(value) : (parameters != null ? (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.RECT_FUNCTION ? new RectImpl(value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.RGBCOLOR ? new RGBColorImpl(value.getFunctionName(), value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.HSLCOLOR ? new HSLColorImpl(value.getFunctionName(), value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.HWBCOLOR ? new HWBColorImpl(value.getFunctionName(), value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.LABCOLOR ? new LABColorImpl(value.getFunctionName(), value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.LCHCOLOR ? new LCHColorImpl(value.getFunctionName(), value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.COUNTER_FUNCTION ? new CounterImpl(false, value.getParameters()) : (value.getLexicalUnitType() == LexicalUnit.LexicalUnitType.COUNTERS_FUNCTION ? new CounterImpl(true, value.getParameters()) : value)))))))) : value);
        if (value != null) {
            this.setLocator(value.getLocator());
        }
    }

    private static List<CSSValueImpl> getValues(LexicalUnit value) {
        ArrayList<CSSValueImpl> values = new ArrayList<CSSValueImpl>();
        for (LexicalUnit lu = value; lu != null; lu = lu.getNextLexicalUnit()) {
            values.add(new CSSValueImpl(lu, true));
        }
        return values;
    }

    public CSSValueImpl(LexicalUnit value) {
        this(value, false);
    }

    public String getCssText() {
        if (this.getCssValueType() == CSSValueType.CSS_VALUE_LIST) {
            StringBuilder sb = new StringBuilder();
            List list = (List)this.value_;
            Iterator it = list.iterator();
            boolean separate = false;
            while (it.hasNext()) {
                Object o = it.next();
                CSSValueImpl cssValue = (CSSValueImpl)o;
                if (separate) {
                    if (cssValue.value_ instanceof LexicalUnit) {
                        LexicalUnit lu = (LexicalUnit)cssValue.value_;
                        if (lu.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                            sb.append(" ");
                        }
                    } else {
                        sb.append(" ");
                    }
                }
                sb.append(o.toString());
                separate = true;
            }
            return sb.toString();
        }
        return this.value_ != null ? this.value_.toString() : "";
    }

    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            CSSValueImpl v2 = parser.parsePropertyValue(cssText);
            this.value_ = v2.value_;
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSValueType getCssValueType() {
        if (this.value_ instanceof List) {
            return CSSValueType.CSS_VALUE_LIST;
        }
        if (this.value_ instanceof LexicalUnit && ((LexicalUnit)this.value_).getLexicalUnitType() == LexicalUnit.LexicalUnitType.INHERIT) {
            return CSSValueType.CSS_INHERIT;
        }
        return CSSValueType.CSS_PRIMITIVE_VALUE;
    }

    public CSSPrimitiveValueType getPrimitiveType() {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            switch (lu.getLexicalUnitType()) {
                case INHERIT: {
                    return CSSPrimitiveValueType.CSS_IDENT;
                }
                case INTEGER: 
                case REAL: {
                    return CSSPrimitiveValueType.CSS_NUMBER;
                }
                case EM: {
                    return CSSPrimitiveValueType.CSS_EMS;
                }
                case REM: {
                    return CSSPrimitiveValueType.CSS_REM;
                }
                case EX: {
                    return CSSPrimitiveValueType.CSS_EXS;
                }
                case CH: {
                    return CSSPrimitiveValueType.CSS_CH;
                }
                case VW: {
                    return CSSPrimitiveValueType.CSS_VW;
                }
                case VH: {
                    return CSSPrimitiveValueType.CSS_VH;
                }
                case VMIN: {
                    return CSSPrimitiveValueType.CSS_VMIN;
                }
                case VMAX: {
                    return CSSPrimitiveValueType.CSS_VMAX;
                }
                case DVW: {
                    return CSSPrimitiveValueType.CSS_DVW;
                }
                case DVH: {
                    return CSSPrimitiveValueType.CSS_DVH;
                }
                case DVMIN: {
                    return CSSPrimitiveValueType.CSS_DVMIN;
                }
                case DVMAX: {
                    return CSSPrimitiveValueType.CSS_DVMAX;
                }
                case LVW: {
                    return CSSPrimitiveValueType.CSS_LVW;
                }
                case LVH: {
                    return CSSPrimitiveValueType.CSS_LVH;
                }
                case LVMIN: {
                    return CSSPrimitiveValueType.CSS_LVMIN;
                }
                case LVMAX: {
                    return CSSPrimitiveValueType.CSS_LVMAX;
                }
                case SVW: {
                    return CSSPrimitiveValueType.CSS_SVW;
                }
                case SVH: {
                    return CSSPrimitiveValueType.CSS_SVH;
                }
                case SVMIN: {
                    return CSSPrimitiveValueType.CSS_SVMIN;
                }
                case SVMAX: {
                    return CSSPrimitiveValueType.CSS_SVMAX;
                }
                case PIXEL: {
                    return CSSPrimitiveValueType.CSS_PX;
                }
                case INCH: {
                    return CSSPrimitiveValueType.CSS_IN;
                }
                case CENTIMETER: {
                    return CSSPrimitiveValueType.CSS_CM;
                }
                case MILLIMETER: {
                    return CSSPrimitiveValueType.CSS_MM;
                }
                case POINT: {
                    return CSSPrimitiveValueType.CSS_PT;
                }
                case PICA: {
                    return CSSPrimitiveValueType.CSS_PC;
                }
                case QUATER: {
                    return CSSPrimitiveValueType.CSS_Q;
                }
                case PERCENTAGE: {
                    return CSSPrimitiveValueType.CSS_PERCENTAGE;
                }
                case URI: {
                    return CSSPrimitiveValueType.CSS_URI;
                }
                case COUNTER_FUNCTION: {
                    return CSSPrimitiveValueType.CSS_COUNTER;
                }
                case DEGREE: {
                    return CSSPrimitiveValueType.CSS_DEG;
                }
                case GRADIAN: {
                    return CSSPrimitiveValueType.CSS_GRAD;
                }
                case RADIAN: {
                    return CSSPrimitiveValueType.CSS_RAD;
                }
                case TURN: {
                    return CSSPrimitiveValueType.CSS_TURN;
                }
                case MILLISECOND: {
                    return CSSPrimitiveValueType.CSS_MS;
                }
                case SECOND: {
                    return CSSPrimitiveValueType.CSS_S;
                }
                case HERTZ: {
                    return CSSPrimitiveValueType.CSS_HZ;
                }
                case KILOHERTZ: {
                    return CSSPrimitiveValueType.CSS_KHZ;
                }
                case IDENT: {
                    return CSSPrimitiveValueType.CSS_IDENT;
                }
                case NONE: {
                    return CSSPrimitiveValueType.CSS_IDENT;
                }
                case STRING_VALUE: {
                    return CSSPrimitiveValueType.CSS_STRING;
                }
                case ATTR: {
                    return CSSPrimitiveValueType.CSS_ATTR;
                }
                case UNICODERANGE: 
                case FUNCTION: 
                case FUNCTION_CALC: {
                    return CSSPrimitiveValueType.CSS_STRING;
                }
                case DIMENSION: {
                    return CSSPrimitiveValueType.CSS_DIMENSION;
                }
            }
            return CSSPrimitiveValueType.CSS_UNKNOWN;
        }
        if (this.value_ instanceof RectImpl) {
            return CSSPrimitiveValueType.CSS_RECT;
        }
        if (this.value_ instanceof RGBColorImpl) {
            return CSSPrimitiveValueType.CSS_RGBCOLOR;
        }
        if (this.value_ instanceof CounterImpl) {
            return CSSPrimitiveValueType.CSS_COUNTER;
        }
        return CSSPrimitiveValueType.CSS_UNKNOWN;
    }

    public LexicalUnit.LexicalUnitType getLexicalUnitType() {
        if (this.value_ instanceof LexicalUnit) {
            return ((LexicalUnit)this.value_).getLexicalUnitType();
        }
        return null;
    }

    public void setDoubleValue(double doubleValue) throws DOMException {
        this.value_ = LexicalUnitImpl.createNumber(null, doubleValue);
    }

    public double getDoubleValue() throws DOMException {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            return lu.getDoubleValue();
        }
        throw new DOMExceptionImpl(15, 9);
    }

    public String getStringValue() throws DOMException {
        if (this.value_ instanceof LexicalUnit) {
            LexicalUnit lu = (LexicalUnit)this.value_;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.IDENT || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.STRING_VALUE || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.URI || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.ATTR) {
                return lu.getStringValue();
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.INHERIT) {
                return "inherit";
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.NONE) {
                return "none";
            }
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.FUNCTION || lu.getLexicalUnitType() == LexicalUnit.LexicalUnitType.FUNCTION_CALC) {
                return lu.toString();
            }
        } else if (this.value_ instanceof List) {
            return null;
        }
        throw new DOMExceptionImpl(15, 10);
    }

    public int getLength() {
        if (this.value_ instanceof List) {
            return ((List)this.value_).size();
        }
        return 0;
    }

    public CSSValueImpl item(int index) {
        if (this.value_ instanceof List) {
            List list = (List)this.value_;
            return (CSSValueImpl)list.get(index);
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSValueImpl)) {
            return false;
        }
        CSSValueImpl cv = (CSSValueImpl)obj;
        return super.equals(obj) && this.getCssValueType() == cv.getCssValueType() && ParserUtils.equals(this.getCssText(), cv.getCssText());
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = ParserUtils.hashCode(hash, this.value_);
        return hash;
    }

    public static enum CSSPrimitiveValueType {
        CSS_IDENT,
        CSS_NUMBER,
        CSS_EMS,
        CSS_EXS,
        CSS_REM,
        CSS_CH,
        CSS_VW,
        CSS_VH,
        CSS_VMIN,
        CSS_VMAX,
        CSS_DVW,
        CSS_DVH,
        CSS_DVMIN,
        CSS_DVMAX,
        CSS_LVW,
        CSS_LVH,
        CSS_LVMIN,
        CSS_LVMAX,
        CSS_SVW,
        CSS_SVH,
        CSS_SVMIN,
        CSS_SVMAX,
        CSS_PX,
        CSS_IN,
        CSS_CM,
        CSS_MM,
        CSS_PT,
        CSS_PC,
        CSS_Q,
        CSS_PERCENTAGE,
        CSS_URI,
        COUNTERS_FUNCTION,
        CSS_RGBCOLOR,
        CSS_DEG,
        CSS_GRAD,
        CSS_RAD,
        CSS_TURN,
        CSS_MS,
        CSS_S,
        CSS_HZ,
        CSS_KHZ,
        CSS_ATTR,
        CSS_RECT,
        CSS_STRING,
        CSS_DIMENSION,
        CSS_COUNTER,
        CSS_UNKNOWN;

    }

    public static enum CSSValueType {
        CSS_VALUE_LIST,
        CSS_INHERIT,
        CSS_PRIMITIVE_VALUE;

    }
}

