/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.util;

import java.util.Arrays;

public class MiniStack<E> {
    private Object[] elements_ = new Object[8];
    private int pos_ = -1;

    public void clear() {
        this.pos_ = -1;
        Arrays.fill(this.elements_, null);
    }

    public void reset() {
        this.pos_ = -1;
    }

    public E pop() {
        if (this.pos_ >= 0) {
            Object e = this.elements_[this.pos_];
            this.elements_[this.pos_] = null;
            --this.pos_;
            return (E)e;
        }
        return null;
    }

    public E peek() {
        return (E)(this.pos_ >= 0 ? this.elements_[this.pos_] : null);
    }

    public void push(E element) {
        ++this.pos_;
        if (this.pos_ == this.elements_.length) {
            this.elements_ = Arrays.copyOf(this.elements_, this.elements_.length + 8);
        }
        this.elements_[this.pos_] = element;
    }

    public boolean isEmpty() {
        return this.pos_ < 0;
    }

    public int size() {
        return this.pos_ + 1;
    }
}

