/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.FormFieldWithNameHistory;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.html.ValidatableElement;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;
import org.w3c.dom.Node;

public class HtmlButton
extends HtmlElement
implements DisabledElement,
SubmittableElement,
LabelableElement,
FormFieldWithNameHistory,
ValidatableElement {
    private static final Log LOG = LogFactory.getLog(HtmlButton.class);
    public static final String TAG_NAME = "button";
    private static final String TYPE_SUBMIT = "submit";
    private static final String TYPE_RESET = "reset";
    private static final String TYPE_BUTTON = "button";
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private String customValidity_;

    HtmlButton(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    public void setValueAttribute(String newValue) {
        this.setAttribute("value", newValue);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form;
        if (!this.isDisabled() && (form = this.getEnclosingForm()) != null) {
            String type = this.getType();
            if ("button".equals(type)) {
                return false;
            }
            if (TYPE_RESET.equals(type)) {
                form.reset();
                return false;
            }
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    @Override
    public final boolean isDisabled() {
        if (this.hasAttribute("disabled")) {
            return true;
        }
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof DisabledElement) || !((DisabledElement)((Object)node)).isDisabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    @Override
    public void reset() {
        LOG.debug("reset() not implemented for this element");
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        LOG.debug("setDefaultValue() not implemented for this element");
    }

    @Override
    public String getDefaultValue() {
        LOG.debug("getDefaultValue() not implemented for this element");
        return "";
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    @Override
    public boolean handles(Event event) {
        if (event instanceof MouseEvent) {
            return true;
        }
        return super.handles(event);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeDirect("value");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public String getType() {
        String type = this.getTypeAttribute();
        if (TYPE_RESET.equalsIgnoreCase(type)) {
            return TYPE_RESET;
        }
        if ("button".equalsIgnoreCase(type)) {
            return "button";
        }
        return TYPE_SUBMIT;
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String qualifiedNameLC = StringUtils.toRootLowerCase(qualifiedName);
        if ("name".equals(qualifiedNameLC)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public boolean isValid() {
        if (TYPE_RESET.equals(this.getType())) {
            return true;
        }
        return super.isValid() && !this.isCustomErrorValidityState();
    }

    @Override
    public boolean willValidate() {
        if (TYPE_RESET.equals(this.getType()) || "button".equals(this.getType())) {
            return false;
        }
        return !this.isDisabled() && (this.hasFeature(BrowserVersionFeatures.HTMLBUTTON_WILL_VALIDATE_IGNORES_READONLY) || !this.isReadOnly());
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !StringUtils.isEmptyOrNull(this.customValidity_);
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState();
    }

    public final boolean isFormNoValidate() {
        return this.hasAttribute("formnovalidate");
    }

    public final void setFormNoValidate(boolean noValidate) {
        if (noValidate) {
            this.setAttribute("formnovalidate", "formnovalidate");
        } else {
            this.removeAttribute("formnovalidate");
        }
    }
}

