/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FormFieldWithNameHistory;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.ValidatableElement;
import org.htmlunit.util.StringUtils;

public class HtmlFieldSet
extends HtmlElement
implements DisabledElement,
ValidatableElement,
FormFieldWithNameHistory {
    public static final String TAG_NAME = "fieldset";
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private String customValidity_;

    HtmlFieldSet(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getAttributeDirect("name");
    }

    @Override
    public boolean willValidate() {
        return false;
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !StringUtils.isEmptyOrNull(this.customValidity_);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState();
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String qualifiedNameLC = StringUtils.toRootLowerCase(qualifiedName);
        if ("name".equals(qualifiedNameLC)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    @Override
    public final boolean isDisabled() {
        if (this.hasAttribute("disabled")) {
            return true;
        }
        for (DomNode node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof DisabledElement) || !((DisabledElement)((Object)node)).isDisabled()) continue;
            return true;
        }
        return false;
    }
}

