/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;

public class HtmlImageInput
extends HtmlInput
implements LabelableElement {
    private boolean wasPositionSpecified_;
    private int xPosition_;
    private int yPosition_;
    private WebResponse imageWebResponse_;
    private boolean downloaded_;

    HtmlImageInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        String name = this.getNameAttribute();
        String prefix = StringUtils.isEmptyOrNull(name) ? "" : name + ".";
        if (this.wasPositionSpecified_) {
            NameValuePair valueX = new NameValuePair(prefix + 'x', Integer.toString(this.xPosition_));
            NameValuePair valueY = new NameValuePair(prefix + 'y', Integer.toString(this.yPosition_));
            return new NameValuePair[]{valueX, valueY};
        }
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getRawValue())};
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    public <P extends Page> P click(int x, int y) throws IOException, ElementNotFoundException {
        this.wasPositionSpecified_ = true;
        this.xPosition_ = x;
        this.yPosition_ = y;
        return super.click();
    }

    @Override
    public <P extends Page> P click(Event event, boolean shiftKey, boolean ctrlKey, boolean altKey, boolean ignoreVisibility) throws IOException {
        this.wasPositionSpecified_ = true;
        return super.click(event, shiftKey, ctrlKey, altKey, ignoreVisibility);
    }

    @Override
    public void setValue(String newValue) {
        this.unmarkValueDirty();
        this.setDefaultValue(newValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setRawValue(defaultValue);
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }

    @Override
    public void setSrcAttribute(String src) {
        super.setSrcAttribute(src);
        this.downloaded_ = false;
        this.imageWebResponse_ = null;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            String src = this.getSrc();
            if (!StringUtils.isEmptyString(src)) {
                HtmlPage page = (HtmlPage)this.getPage();
                WebClient webClient = page.getWebClient();
                BrowserVersion browser = webClient.getBrowserVersion();
                WebRequest request = new WebRequest(new URL(src), browser.getImgAcceptHeader(), browser.getAcceptEncodingHeader());
                request.setCharset(page.getCharset());
                request.setRefererHeader(page.getUrl());
                this.imageWebResponse_ = webClient.loadWebResponse(request);
            }
            this.downloaded_ = true;
        }
    }

    public void saveAs(File file) throws IOException {
        this.downloadImageIfNeeded();
        if (null != this.imageWebResponse_) {
            try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 InputStream inputStream = this.imageWebResponse_.getContentAsStream();){
                IOUtils.copy(inputStream, fos);
            }
        }
    }
}

