/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlSelectableTextInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.util.ArrayUtils;
import org.htmlunit.util.StringUtils;

public class HtmlNumberInput
extends HtmlSelectableTextInput
implements LabelableElement {
    private static final char[] VALID_INT_CHARS = "0123456789-".toCharArray();
    private static final char[] VALID_CHARS = "0123456789-+.eE".toCharArray();

    HtmlNumberInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        String value = this.getValueAttribute();
        if (!value.isEmpty() && !StringUtils.containsOnly(value, VALID_CHARS)) {
            this.setRawValue("");
        }
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    protected void doType(char c, boolean lastType) {
        if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL) && !ArrayUtils.contains(VALID_CHARS, c)) {
            return;
        }
        super.doType(c, lastType);
    }

    @Override
    public String getValue() {
        String raw = this.getRawValue();
        if (StringUtils.isBlank(raw)) {
            return "";
        }
        if (StringUtils.equalsChar('-', raw) || StringUtils.equalsChar('+', raw)) {
            return raw;
        }
        try {
            String lang = ((SgmlPage)this.getPage()).getWebClient().getBrowserVersion().getBrowserLanguage();
            NumberFormat format = NumberFormat.getInstance(Locale.forLanguageTag(lang));
            format.parse(raw);
            return raw.trim();
        }
        catch (ParseException parseException) {
            if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL)) {
                return raw;
            }
            return "";
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String rawValue = this.getRawValue();
        if (StringUtils.isBlank(rawValue)) {
            return true;
        }
        if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_ACCEPT_ALL)) {
            rawValue = rawValue.replaceAll("\\s", "");
        }
        if (!rawValue.isEmpty()) {
            BigDecimal value;
            block22: {
                if (StringUtils.equalsChar('-', rawValue) || StringUtils.equalsChar('+', rawValue)) {
                    return false;
                }
                if (this.getStep().isEmpty()) {
                    String val = rawValue;
                    int lastPos = val.length() - 1;
                    if (lastPos >= 0 && val.charAt(lastPos) == '.') {
                        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_NUMBER_DOT_AT_END_IS_DOUBLE)) {
                            return false;
                        }
                        val = val.substring(0, lastPos);
                    }
                    if (!StringUtils.containsOnly(val, VALID_INT_CHARS)) {
                        return false;
                    }
                }
                try {
                    value = new BigDecimal(rawValue);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (!this.getMin().isEmpty()) {
                    try {
                        BigDecimal min = new BigDecimal(this.getMin());
                        if (value.compareTo(min) < 0) {
                            return false;
                        }
                        if (this.getStep().isEmpty()) break block22;
                        try {
                            BigDecimal step = new BigDecimal(this.getStep());
                            if (value.subtract(min).abs().remainder(step).doubleValue() > 0.0) {
                                return false;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    catch (NumberFormatException min) {
                        // empty catch block
                    }
                }
            }
            if (!this.getMax().isEmpty()) {
                try {
                    BigDecimal max = new BigDecimal(this.getMax());
                    if (value.compareTo(max) > 0) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return true;
    }
}

