/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Cache;
import org.htmlunit.SgmlPage;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.parser.InputSource;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;

public class HtmlStyle
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlStyle.class);
    public static final String TAG_NAME = "style";
    private CssStyleSheet sheet_;

    HtmlStyle(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getTypeAttribute() {
        return this.getAttributeDirect("type");
    }

    public final void setTypeAttribute(String type) {
        this.setAttribute("type", type);
    }

    public final String getMediaAttribute() {
        return this.getAttributeDirect("media");
    }

    public final String getTitleAttribute() {
        return this.getAttributeDirect("title");
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    public CssStyleSheet getSheet() {
        if (this.sheet_ != null) {
            return this.sheet_;
        }
        Cache cache = this.getPage().getWebClient().getCache();
        CSSStyleSheetImpl cached = cache.getCachedStyleSheet(this.getTextContent());
        String uri = this.getPage().getWebResponse().getWebRequest().getUrl().toExternalForm();
        if (cached != null) {
            this.sheet_ = new CssStyleSheet((HtmlElement)this, cached, uri);
        } else {
            String css = this.getTextContent();
            try (InputSource source = new InputSource(new StringReader(css));){
                this.sheet_ = new CssStyleSheet((HtmlElement)this, source, uri);
                cache.cache(css, this.sheet_.getWrappedSheet());
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        return this.sheet_;
    }
}

