/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.httpclient;

import java.util.Date;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.util.Args;

final class HtmlUnitMaxAgeHandler
extends BasicMaxAgeHandler {
    HtmlUnitMaxAgeHandler() {
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value, e);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }
}

