/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.httpclient;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.htmlunit.BrowserVersion;
import org.htmlunit.httpclient.HtmlUnitBrowserCompatCookieSpec;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.UrlUtils;

public final class HttpClientConverter {
    private HttpClientConverter() {
    }

    public static List<NameValuePair> nameValuePairsToHttpClient(List<org.htmlunit.util.NameValuePair> pairs) {
        ArrayList<NameValuePair> resultingPairs = new ArrayList<NameValuePair>(pairs.size());
        for (org.htmlunit.util.NameValuePair pair : pairs) {
            resultingPairs.add(new BasicNameValuePair(pair.getName(), pair.getValue()));
        }
        return resultingPairs;
    }

    public static boolean isNoHttpResponseException(Exception e) {
        return e instanceof NoHttpResponseException;
    }

    public static CookieOrigin buildCookieOrigin(URL url) {
        URL normalizedUrl = HttpClientConverter.replaceForCookieIfNecessary(url);
        int port = normalizedUrl.getPort();
        if (port == -1) {
            port = normalizedUrl.getDefaultPort();
        }
        return new CookieOrigin(normalizedUrl.getHost(), port, normalizedUrl.getPath(), "https".equals(normalizedUrl.getProtocol()));
    }

    public static URL replaceForCookieIfNecessary(URL url) {
        String protocol = url.getProtocol();
        boolean file = "file".equals(protocol);
        if (file) {
            try {
                url = UrlUtils.getUrlWithNewHostAndPort(url, "LOCAL_FILESYSTEM", 0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public static List<Cookie> parseCookie(String cookieString, URL pageUrl, BrowserVersion browserVersion) throws MalformedCookieException {
        CharArrayBuffer buffer = new CharArrayBuffer(cookieString.length() + 22);
        buffer.append("Set-Cookie: ");
        buffer.append(cookieString);
        HtmlUnitBrowserCompatCookieSpec cookieSpec = new HtmlUnitBrowserCompatCookieSpec(browserVersion);
        List<org.apache.http.cookie.Cookie> cookies = cookieSpec.parse(new BufferedHeader(buffer), HttpClientConverter.buildCookieOrigin(pageUrl));
        ArrayList<Cookie> htmlUnitCookies = new ArrayList<Cookie>(cookies.size());
        for (org.apache.http.cookie.Cookie cookie : cookies) {
            Cookie htmlUnitCookie = new Cookie((ClientCookie)cookie);
            htmlUnitCookies.add(htmlUnitCookie);
        }
        return htmlUnitCookies;
    }

    public static List<org.apache.http.cookie.Cookie> toHttpClient(Collection<Cookie> cookies) {
        ArrayList<org.apache.http.cookie.Cookie> array = new ArrayList<org.apache.http.cookie.Cookie>(cookies.size());
        for (Cookie cookie : cookies) {
            array.add(cookie.toHttpClient());
        }
        return array;
    }

    public static List<Cookie> fromHttpClient(List<org.apache.http.cookie.Cookie> cookies) {
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.size());
        for (org.apache.http.cookie.Cookie c : cookies) {
            list.add(new Cookie((ClientCookie)c));
        }
        return list;
    }

    public static void addMatching(Set<Cookie> cookies, URL normalizedUrl, BrowserVersion browserVersion, Set<Cookie> matches) {
        if (!cookies.isEmpty()) {
            CookieOrigin cookieOrigin = HttpClientConverter.buildCookieOrigin(normalizedUrl);
            HtmlUnitBrowserCompatCookieSpec cookieSpec = new HtmlUnitBrowserCompatCookieSpec(browserVersion);
            for (Cookie cookie : cookies) {
                if (!cookieSpec.match(cookie.toHttpClient(), cookieOrigin)) continue;
                matches.add(cookie);
            }
        }
    }
}

