/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.ScriptException;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.JavaScriptErrorListener;

public class DefaultJavaScriptErrorListener
implements JavaScriptErrorListener,
Serializable {
    private static final Log LOG = LogFactory.getLog(DefaultJavaScriptErrorListener.class);

    @Override
    public void scriptException(HtmlPage page, ScriptException scriptException) {
        LOG.error("Error during JavaScript execution", scriptException);
    }

    @Override
    public void timeoutError(HtmlPage page, long allowedTime, long executionTime) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Timeout during JavaScript execution after " + executionTime + "ms; allowed only " + allowedTime + "ms");
        }
    }

    @Override
    public void malformedScriptURL(HtmlPage page, String url, MalformedURLException malformedURLException) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Unable to build URL for script src tag [" + url + "]", malformedURLException);
        }
    }

    @Override
    public void loadScriptError(HtmlPage page, URL scriptUrl, Exception exception) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Error loading JavaScript from [" + scriptUrl + "].", exception);
        }
    }

    @Override
    public void warn(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (LOG.isWarnEnabled()) {
            StringBuilder msg = new StringBuilder().append("warning: message=[").append(message).append("] sourceName=[").append(sourceName).append("] line=[").append(line).append("] lineSource=[").append(lineSource).append("] lineOffset=[").append(lineOffset).append(']');
            LOG.warn(msg.toString());
        }
    }
}

