/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.text.NumberFormat;
import java.util.IllformedLocaleException;
import java.util.Locale;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.JavaScriptEngine;

public final class NumberCustom {
    private NumberCustom() {
    }

    public static String toLocaleString(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (args.length != 0 && args[0] instanceof String) {
            String localeStr = (String)args[0];
            try {
                Locale locale = new Locale.Builder().setLanguageTag(localeStr).build();
                return NumberFormat.getInstance(locale).format(Double.parseDouble(thisObj.toString()));
            }
            catch (IllformedLocaleException e) {
                throw JavaScriptEngine.rangeError("Invalid language tag: " + localeStr);
            }
        }
        return NumberFormat.getInstance(context.getLocale()).format(Double.parseDouble(thisObj.toString()));
    }
}

