/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.event.CloseEvent;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.event.MessageEvent;
import org.htmlunit.util.UrlUtils;
import org.htmlunit.websocket.WebSocketAdapter;
import org.htmlunit.websocket.WebSocketListener;

@JsxClass
public class WebSocket
extends EventTarget
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(WebSocket.class);
    @JsxConstant
    public static final int CONNECTING = 0;
    @JsxConstant
    public static final int OPEN = 1;
    @JsxConstant
    public static final int CLOSING = 2;
    @JsxConstant
    public static final int CLOSED = 3;
    private Function closeHandler_;
    private Function errorHandler_;
    private Function messageHandler_;
    private Function openHandler_;
    private URI url_;
    private int readyState_ = 0;
    private String binaryType_ = "blob";
    private HtmlPage containingPage_;
    private WebSocketAdapter webSocketImpl_;
    private boolean originSet_;

    public WebSocket() {
    }

    private WebSocket(final String url, final Window window) {
        try {
            WebWindow webWindow = window.getWebWindow();
            this.containingPage_ = (HtmlPage)webWindow.getEnclosedPage();
            this.setParentScope(window);
            this.setDomNode(this.containingPage_.getDocumentElement(), false);
            WebClient webClient = webWindow.getWebClient();
            this.originSet_ = true;
            WebSocketListener webSocketListener = new WebSocketListener(){

                @Override
                public void onWebSocketConnecting() {
                    WebSocket.this.setReadyState(0);
                }

                @Override
                public void onWebSocketConnect() {
                    WebSocket.this.setReadyState(1);
                    Event openEvent = new Event("open");
                    openEvent.setParentScope(window);
                    openEvent.setPrototype(WebSocket.this.getPrototype(openEvent.getClass()));
                    openEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(openEvent);
                    WebSocket.this.callFunction(WebSocket.this.openHandler_, new Object[]{openEvent});
                }

                @Override
                public void onWebSocketClose(int statusCode, String reason) {
                    WebSocket.this.setReadyState(3);
                    CloseEvent closeEvent = new CloseEvent();
                    closeEvent.setParentScope(window);
                    closeEvent.setPrototype(WebSocket.this.getPrototype(closeEvent.getClass()));
                    closeEvent.setCode(statusCode);
                    closeEvent.setReason(reason);
                    closeEvent.setWasClean(true);
                    WebSocket.this.fire(closeEvent);
                    WebSocket.this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
                }

                @Override
                public void onWebSocketText(String message) {
                    MessageEvent msgEvent = new MessageEvent((Object)message);
                    msgEvent.setParentScope(window);
                    msgEvent.setPrototype(WebSocket.this.getPrototype(msgEvent.getClass()));
                    if (WebSocket.this.originSet_) {
                        msgEvent.setOrigin(WebSocket.this.getUrl());
                    }
                    msgEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(msgEvent);
                    WebSocket.this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
                }

                @Override
                public void onWebSocketBinary(byte[] data, int offset, int length) {
                    NativeArrayBuffer buffer = new NativeArrayBuffer((double)length);
                    System.arraycopy(data, offset, buffer.getBuffer(), 0, length);
                    buffer.setParentScope(WebSocket.this.getParentScope());
                    buffer.setPrototype(ScriptableObject.getClassPrototype(WebSocket.this.getWindow(), buffer.getClassName()));
                    MessageEvent msgEvent = new MessageEvent(buffer);
                    msgEvent.setParentScope(window);
                    msgEvent.setPrototype(WebSocket.this.getPrototype(msgEvent.getClass()));
                    if (WebSocket.this.originSet_) {
                        msgEvent.setOrigin(WebSocket.this.getUrl());
                    }
                    msgEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(msgEvent);
                    WebSocket.this.callFunction(WebSocket.this.messageHandler_, new Object[]{msgEvent});
                }

                @Override
                public void onWebSocketConnectError(Throwable cause) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("WS connect error for url '" + url + "':", cause);
                    }
                }

                @Override
                public void onWebSocketError(Throwable cause) {
                    WebSocket.this.setReadyState(3);
                    Event errorEvent = new Event("error");
                    errorEvent.setParentScope(window);
                    errorEvent.setPrototype(WebSocket.this.getPrototype(errorEvent.getClass()));
                    errorEvent.setSrcElement(WebSocket.this);
                    WebSocket.this.fire(errorEvent);
                    WebSocket.this.callFunction(WebSocket.this.errorHandler_, new Object[]{errorEvent});
                    CloseEvent closeEvent = new CloseEvent();
                    closeEvent.setParentScope(window);
                    closeEvent.setPrototype(WebSocket.this.getPrototype(closeEvent.getClass()));
                    closeEvent.setCode(1006);
                    closeEvent.setReason(cause.getMessage());
                    closeEvent.setWasClean(false);
                    WebSocket.this.fire(closeEvent);
                    WebSocket.this.callFunction(WebSocket.this.closeHandler_, new Object[]{closeEvent});
                }
            };
            this.webSocketImpl_ = webClient.buildWebSocketAdapter(webSocketListener);
            this.webSocketImpl_.start();
            this.containingPage_.addAutoCloseable(this);
            this.url_ = new URI(url);
            this.webSocketImpl_.connect(this.url_);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("WebSocket Error: 'url' parameter '" + url + "' is invalid.", e);
            }
            throw JavaScriptEngine.reportRuntimeError("WebSocket Error: 'url' parameter '" + url + "' is invalid.");
        }
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length < 1 || args.length > 2) {
            throw JavaScriptEngine.reportRuntimeError("WebSocket Error: constructor must have one or two String parameters.");
        }
        Window win = WebSocket.getWindow(ctorObj);
        String urlString = JavaScriptEngine.toString(args[0]);
        try {
            Page page = win.getWebWindow().getEnclosedPage();
            if (page instanceof HtmlPage) {
                URL url = ((HtmlPage)page).getFullyQualifiedUrl(urlString);
                url = UrlUtils.getUrlWithNewProtocol(url, "ws");
                urlString = url.toExternalForm();
            }
        }
        catch (MalformedURLException e) {
            throw JavaScriptEngine.reportRuntimeError("WebSocket Error: 'url' parameter '" + urlString + "' is not a valid url.");
        }
        return new WebSocket(urlString, win);
    }

    @JsxGetter
    public Function getOnclose() {
        return this.closeHandler_;
    }

    @JsxSetter
    public void setOnclose(Function closeHandler) {
        this.closeHandler_ = closeHandler;
    }

    @JsxGetter
    public Function getOnerror() {
        return this.errorHandler_;
    }

    @JsxSetter
    public void setOnerror(Function errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.messageHandler_;
    }

    @JsxSetter
    public void setOnmessage(Function messageHandler) {
        this.messageHandler_ = messageHandler;
    }

    @JsxGetter
    public Function getOnopen() {
        return this.openHandler_;
    }

    @JsxSetter
    public void setOnopen(Function openHandler) {
        this.openHandler_ = openHandler;
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    void setReadyState(int readyState) {
        this.readyState_ = readyState;
    }

    @JsxGetter
    public String getUrl() {
        if (this.url_ == null) {
            throw JavaScriptEngine.typeError("invalid call");
        }
        return this.url_.toString();
    }

    @JsxGetter
    public String getProtocol() {
        return "";
    }

    @JsxGetter
    public long getBufferedAmount() {
        return 0L;
    }

    @JsxGetter
    public String getBinaryType() {
        return this.binaryType_;
    }

    @JsxSetter
    public void setBinaryType(String type) {
        if ("arraybuffer".equals(type) || "blob".equals(type)) {
            this.binaryType_ = type;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null, null);
    }

    @JsxFunction
    public void close(Object code, Object reason) {
        if (this.readyState_ != 3) {
            try {
                this.webSocketImpl_.closeIncommingSession();
            }
            catch (Throwable e) {
                LOG.error("WS close error - incomingSession_.close() failed", e);
            }
            try {
                this.webSocketImpl_.closeOutgoingSession();
            }
            catch (Throwable e) {
                LOG.error("WS close error - outgoingSession_.close() failed", e);
            }
        }
        try {
            this.webSocketImpl_.closeClient();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsxFunction
    public void send(Object content) {
        try {
            if (content instanceof NativeArrayBuffer) {
                byte[] bytes = ((NativeArrayBuffer)content).getBuffer();
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                this.webSocketImpl_.send(buffer);
                return;
            }
            this.webSocketImpl_.send(content);
        }
        catch (IOException e) {
            LOG.error("WS send error", e);
        }
    }

    void fire(Event evt) {
        evt.setTarget(this);
        evt.setParentScope(this.getParentScope());
        evt.setPrototype(this.getPrototype(evt.getClass()));
        AbstractJavaScriptEngine<?> engine = this.containingPage_.getWebClient().getJavaScriptEngine();
        engine.getContextFactory().call(cx -> {
            this.executeEventLocally(evt);
            return null;
        });
    }

    void callFunction(Function function, Object[] args) {
        if (function == null) {
            return;
        }
        Scriptable scope = function.getParentScope();
        JavaScriptEngine engine = (JavaScriptEngine)this.containingPage_.getWebClient().getJavaScriptEngine();
        engine.callFunction(this.containingPage_, function, scope, this, args);
    }
}

