/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.canvas;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.canvas.CanvasGradient;
import org.htmlunit.javascript.host.canvas.ImageData;
import org.htmlunit.javascript.host.canvas.Path2D;
import org.htmlunit.javascript.host.canvas.TextMetrics;
import org.htmlunit.javascript.host.html.HTMLCanvasElement;
import org.htmlunit.javascript.host.html.HTMLImageElement;
import org.htmlunit.platform.Platform;
import org.htmlunit.platform.canvas.rendering.RenderingBackend;

@JsxClass
public class CanvasRenderingContext2D
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(CanvasRenderingContext2D.class);
    private HTMLCanvasElement canvas_;
    private RenderingBackend renderingBackend_;

    public CanvasRenderingContext2D() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public CanvasRenderingContext2D(HTMLCanvasElement canvas) {
        this.canvas_ = canvas;
        this.renderingBackend_ = null;
    }

    private RenderingBackend getRenderingBackend() {
        if (this.renderingBackend_ == null) {
            int imageWidth = Math.max(1, this.canvas_.getWidth());
            int imageHeight = Math.max(1, this.canvas_.getHeight());
            this.renderingBackend_ = Platform.getRenderingBackend(imageWidth, imageHeight);
        }
        return this.renderingBackend_;
    }

    @JsxGetter
    public double getGlobalAlpha() {
        return this.getRenderingBackend().getGlobalAlpha();
    }

    @JsxSetter
    public void setGlobalAlpha(double globalAlpha) {
        this.getRenderingBackend().setGlobalAlpha(globalAlpha);
    }

    @JsxGetter
    public HtmlUnitScriptable getFillStyle() {
        LOG.info("CanvasRenderingContext2D.getFillStyle() not yet implemented");
        return null;
    }

    @JsxSetter
    public void setFillStyle(String fillStyle) {
        this.getRenderingBackend().setFillStyle(fillStyle);
    }

    @JsxGetter
    public HtmlUnitScriptable getStrokeStyle() {
        LOG.info("CanvasRenderingContext2D.getStrokeStyle() not yet implemented");
        return null;
    }

    @JsxSetter
    public void setStrokeStyle(String strokeStyle) {
        this.getRenderingBackend().setStrokeStyle(strokeStyle);
    }

    @JsxGetter
    public double getLineWidth() {
        return this.getRenderingBackend().getLineWidth();
    }

    @JsxSetter
    public void setLineWidth(Object lineWidth) {
        double width;
        if (!JavaScriptEngine.isUndefined(lineWidth) && !Double.isNaN(width = JavaScriptEngine.toNumber(lineWidth))) {
            this.getRenderingBackend().setLineWidth((int)width);
        }
    }

    @JsxFunction
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        this.getRenderingBackend().arc(x, y, radius, startAngle, endAngle, anticlockwise);
    }

    @JsxFunction
    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        LOG.info("CanvasRenderingContext2D.arcTo() not yet implemented");
    }

    @JsxFunction
    public void beginPath() {
        this.getRenderingBackend().beginPath();
    }

    @JsxFunction
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.getRenderingBackend().bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    }

    @JsxFunction
    public void clearRect(double x, double y, double w, double h) {
        this.getRenderingBackend().clearRect(x, y, w, h);
    }

    @JsxFunction
    public static void clip(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        String windingRuleParam;
        if (!(thisObj instanceof CanvasRenderingContext2D)) {
            throw JavaScriptEngine.reportRuntimeError("CanvasRenderingContext2D.getImageData() failed - this is not a CanvasRenderingContext2D");
        }
        CanvasRenderingContext2D canvas = (CanvasRenderingContext2D)thisObj;
        RenderingBackend.WindingRule windingRule = RenderingBackend.WindingRule.NON_ZERO;
        if (args.length == 1) {
            windingRuleParam = JavaScriptEngine.toString(args[0]);
            if ("evenodd".contentEquals(windingRuleParam)) {
                windingRule = RenderingBackend.WindingRule.EVEN_ODD;
            }
            canvas.getRenderingBackend().clip(windingRule, null);
        }
        if (args.length > 1) {
            if (!(args[0] instanceof Path2D)) {
                throw JavaScriptEngine.reportRuntimeError("CanvasRenderingContext2D.clip() failed - the first parameter has to be a Path2D");
            }
            windingRuleParam = JavaScriptEngine.toString(args[1]);
            if ("evenodd".contentEquals(windingRuleParam)) {
                windingRule = RenderingBackend.WindingRule.EVEN_ODD;
            }
            LOG.info("CanvasRenderingContext2D.clip(path, fillRule) not yet implemented");
        }
        canvas.getRenderingBackend().clip(RenderingBackend.WindingRule.NON_ZERO, null);
    }

    @JsxFunction
    public void closePath() {
        this.getRenderingBackend().closePath();
    }

    @JsxFunction
    public static ImageData createImageData(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof CanvasRenderingContext2D)) {
            throw JavaScriptEngine.reportRuntimeError("CanvasRenderingContext2D.getImageData() failed - this is not a CanvasRenderingContext2D");
        }
        CanvasRenderingContext2D canvas = (CanvasRenderingContext2D)thisObj;
        if (args.length > 0 && args[0] instanceof ImageData) {
            ImageData imageDataParameter = (ImageData)args[0];
            ImageData imageData = new ImageData(null, 0, 0, imageDataParameter.getWidth(), imageDataParameter.getHeight());
            imageData.setParentScope(canvas.getParentScope());
            imageData.setPrototype(canvas.getPrototype(imageData.getClass()));
            return imageData;
        }
        if (args.length > 1) {
            int width = Math.abs((int)JavaScriptEngine.toInteger(args, 0));
            int height = Math.abs((int)JavaScriptEngine.toInteger(args, 1));
            ImageData imageData = new ImageData(null, 0, 0, width, height);
            imageData.setParentScope(canvas.getParentScope());
            imageData.setPrototype(canvas.getPrototype(imageData.getClass()));
            return imageData;
        }
        throw JavaScriptEngine.reportRuntimeError("CanvasRenderingContext2D.getImageData() failed - wrong parameters given (" + StringUtils.join(args, ", ") + ")");
    }

    @JsxFunction
    public CanvasGradient createLinearGradient(double x0, double y0, double r0, double x1, Object y1, Object r1) {
        CanvasGradient canvasGradient = new CanvasGradient();
        canvasGradient.setParentScope(this.getParentScope());
        canvasGradient.setPrototype(this.getPrototype(canvasGradient.getClass()));
        return canvasGradient;
    }

    @JsxFunction
    public void createPattern() {
        LOG.info("CanvasRenderingContext2D.createPattern() not yet implemented");
    }

    @JsxFunction
    public CanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1) {
        CanvasGradient canvasGradient = new CanvasGradient();
        canvasGradient.setParentScope(this.getParentScope());
        canvasGradient.setPrototype(this.getPrototype(canvasGradient.getClass()));
        return canvasGradient;
    }

    @JsxFunction
    public void drawImage(Object image, int sx, int sy, Object sWidth, Object sHeight, Object dx, Object dy, Object dWidth, Object dHeight) {
        if (image instanceof HTMLImageElement) {
            HTMLImageElement imageElem = (HTMLImageElement)image;
            try {
                org.htmlunit.platform.image.ImageData imageData = ((HtmlImage)imageElem.getDomNodeOrDie()).getImageData();
                if (JavaScriptEngine.isUndefined(sWidth)) {
                    this.getRenderingBackend().drawImage(imageData, 0, 0, null, null, sx, sy, null, null);
                } else if (JavaScriptEngine.isUndefined(dx)) {
                    int dWidthI = JavaScriptEngine.toInt32(sWidth);
                    int dHeightI = JavaScriptEngine.toInt32(sHeight);
                    this.getRenderingBackend().drawImage(imageData, 0, 0, null, null, sx, sy, dWidthI, dHeightI);
                } else {
                    int sWidthI = JavaScriptEngine.toInt32(sWidth);
                    int sHeightI = JavaScriptEngine.toInt32(sHeight);
                    int dxI = JavaScriptEngine.toInt32(dx);
                    int dyI = JavaScriptEngine.toInt32(dy);
                    int dWidthI = JavaScriptEngine.toInt32(dWidth);
                    int dHeightI = JavaScriptEngine.toInt32(dHeight);
                    this.getRenderingBackend().drawImage(imageData, sx, sy, sWidthI, sHeightI, dxI, dyI, dWidthI, dHeightI);
                }
            }
            catch (IOException ex) {
                LOG.info("There is no ImageReader available for you imgage with src '" + imageElem.getSrc() + "'Please have a look at https://www.htmlunit.org/images-howto.html for a possible solution.");
            }
        }
    }

    public String toDataURL(String type) {
        try {
            if (type == null) {
                type = "image/png";
            }
            return "data:" + type + ";base64," + this.getRenderingBackend().encodeToString(type);
        }
        catch (IOException ex) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(ex);
        }
    }

    @JsxFunction
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        this.getRenderingBackend().ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
    }

    @JsxFunction
    public void fill() {
        this.getRenderingBackend().fill();
    }

    @JsxFunction
    public void fillRect(int x, int y, int w, int h) {
        this.getRenderingBackend().fillRect(x, y, w, h);
    }

    @JsxFunction
    public void fillText(String text, double x, double y) {
        this.getRenderingBackend().fillText(text, x, y);
    }

    @JsxFunction
    public ImageData getImageData(int sx, int sy, int sw, int sh) {
        ImageData imageData = new ImageData(this.getRenderingBackend(), sx, sy, sw, sh);
        imageData.setParentScope(this.getParentScope());
        imageData.setPrototype(this.getPrototype(imageData.getClass()));
        return imageData;
    }

    @JsxFunction(functionName="getLineDash")
    public void lineDash() {
        LOG.info("CanvasRenderingContext2D.getLineDash() not yet implemented");
    }

    @JsxFunction(functionName="getLineData")
    public void lineData() {
        LOG.info("CanvasRenderingContext2D.getLineData() not yet implemented");
    }

    @JsxFunction
    public void isPointInPath() {
        LOG.info("CanvasRenderingContext2D.isPointInPath() not yet implemented");
    }

    @JsxFunction
    public void lineTo(double x, double y) {
        this.getRenderingBackend().lineTo(x, y);
    }

    @JsxFunction
    public TextMetrics measureText(Object text) {
        if (text == null || JavaScriptEngine.isUndefined(text)) {
            throw JavaScriptEngine.typeError("Missing argument for CanvasRenderingContext2D.measureText().");
        }
        String textValue = JavaScriptEngine.toString(text);
        int width = textValue.length() * this.getBrowserVersion().getPixesPerChar();
        TextMetrics metrics = new TextMetrics(width);
        metrics.setParentScope(this.getParentScope());
        metrics.setPrototype(this.getPrototype(metrics.getClass()));
        return metrics;
    }

    @JsxFunction
    public void moveTo(double x, double y) {
        this.getRenderingBackend().moveTo(x, y);
    }

    @JsxFunction
    public void putImageData(ImageData imageData, int dx, int dy, Object dirtyX, Object dirtyY, Object dirtyWidth, Object dirtyHeight) {
        int dirtyXArg = 0;
        int dirtyYArg = 0;
        int dirtyWidthArg = imageData.getWidth();
        int dirtyHeightArg = imageData.getHeight();
        if (!JavaScriptEngine.isUndefined(dirtyX)) {
            dirtyXArg = (int)JavaScriptEngine.toInteger(dirtyX);
            if (JavaScriptEngine.isUndefined(dirtyY) || JavaScriptEngine.isUndefined(dirtyWidth) || JavaScriptEngine.isUndefined(dirtyHeight)) {
                throw JavaScriptEngine.reportRuntimeError("CanvasRenderingContext2D.putImageData() failed - seven parameters expected");
            }
            dirtyYArg = (int)JavaScriptEngine.toInteger(dirtyY);
            dirtyWidthArg = (int)JavaScriptEngine.toInteger(dirtyWidth);
            dirtyHeightArg = (int)JavaScriptEngine.toInteger(dirtyHeight);
        }
        this.getRenderingBackend().putImageData(imageData.getData().getBuffer().getBuffer(), imageData.getHeight(), imageData.getWidth(), dx, dy, dirtyXArg, dirtyYArg, dirtyWidthArg, dirtyHeightArg);
    }

    @JsxFunction
    public void quadraticCurveTo(double controlPointX, double controlPointY, double endPointX, double endPointY) {
        this.getRenderingBackend().quadraticCurveTo(controlPointX, controlPointY, endPointX, endPointY);
    }

    @JsxFunction
    public void rect(double x, double y, double w, double h) {
        this.getRenderingBackend().rect(x, y, w, h);
    }

    @JsxFunction
    public void restore() {
        this.getRenderingBackend().restore();
    }

    @JsxFunction
    public void rotate(double angle) {
        this.getRenderingBackend().rotate(angle);
    }

    @JsxFunction
    public void save() {
        this.getRenderingBackend().save();
    }

    @JsxFunction
    public void scale(Object x, Object y) {
        LOG.info("CanvasRenderingContext2D.scale() not yet implemented");
    }

    @JsxFunction
    public void setLineDash() {
        LOG.info("CanvasRenderingContext2D.setLineDash() not yet implemented");
    }

    @JsxFunction
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.getRenderingBackend().setTransform(m11, m12, m21, m22, dx, dy);
    }

    @JsxFunction
    public void stroke() {
        this.getRenderingBackend().stroke();
    }

    @JsxFunction
    public void strokeRect(int x, int y, int w, int h) {
        this.getRenderingBackend().strokeRect(x, y, w, h);
    }

    @JsxFunction
    public void strokeText() {
        LOG.info("CanvasRenderingContext2D.strokeText() not yet implemented");
    }

    @JsxFunction
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.getRenderingBackend().transform(m11, m12, m21, m22, dx, dy);
    }

    @JsxFunction
    public void translate(int x, int y) {
        this.getRenderingBackend().translate(x, y);
    }

    @JsxGetter
    public HTMLCanvasElement getCanvas() {
        return this.canvas_;
    }
}

