/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.crypto;

import java.security.SecureRandom;
import java.util.Locale;
import org.htmlunit.corejs.javascript.typedarrays.NativeTypedArrayView;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.crypto.SubtleCrypto;

@JsxClass
public class Crypto
extends HtmlUnitScriptable {
    static final SecureRandom RANDOM = new SecureRandom();

    public Crypto() {
    }

    @JsxConstructor
    public void jsConstructor() {
        throw JavaScriptEngine.typeErrorIllegalConstructor();
    }

    public Crypto(Window window) {
        this();
        this.setParentScope(window);
        this.setPrototype(window.getPrototype(Crypto.class));
    }

    @JsxFunction
    public NativeTypedArrayView<?> getRandomValues(NativeTypedArrayView<?> array) {
        if (array == null) {
            throw JavaScriptEngine.typeError("Argument 1 of Crypto.getRandomValues is not an object.");
        }
        if (array.getByteLength() > 65536) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Error: Failed to execute 'getRandomValues' on 'Crypto': The ArrayBufferView's byte length (" + array.getByteLength() + ") exceeds the number of bytes of entropy available via this API (65536).", 22);
        }
        int length = array.getByteLength() / array.getBytesPerElement();
        for (int i = 0; i < length; ++i) {
            array.put(i, array, (Object)RANDOM.nextInt());
        }
        return array;
    }

    @JsxGetter
    public SubtleCrypto getSubtle() {
        SubtleCrypto stuble = new SubtleCrypto();
        Window window = this.getWindow();
        stuble.setParentScope(window);
        stuble.setPrototype(window.getPrototype(SubtleCrypto.class));
        return stuble;
    }

    @JsxFunction
    public String randomUUID() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] | 0x40);
        bytes[6] = (byte)(bytes[6] & 0x4F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        bytes[8] = (byte)(bytes[6] & 0xBF);
        StringBuilder result = new StringBuilder().append(Crypto.toHex(bytes[0])).append(Crypto.toHex(bytes[1])).append(Crypto.toHex(bytes[2])).append(Crypto.toHex(bytes[3])).append('-').append(Crypto.toHex(bytes[4])).append(Crypto.toHex(bytes[5])).append('-').append(Crypto.toHex(bytes[6])).append(Crypto.toHex(bytes[7])).append('-').append(Crypto.toHex(bytes[8])).append(Crypto.toHex(bytes[9])).append('-').append(Crypto.toHex(bytes[10])).append(Crypto.toHex(bytes[11])).append(Crypto.toHex(bytes[12])).append(Crypto.toHex(bytes[13])).append(Crypto.toHex(bytes[14])).append(Crypto.toHex(bytes[15]));
        return result.toString();
    }

    private static String toHex(byte b) {
        return String.format("%02X ", b).trim().toLowerCase(Locale.ROOT);
    }
}

