/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxStaticFunction;
import org.htmlunit.util.StringUtils;

@JsxClass
public class CSS
extends HtmlUnitScriptable {
    @Override
    public Object get(String name, Scriptable start) {
        if ("prototype".equals(name)) {
            return NOT_FOUND;
        }
        return super.get(name, start);
    }

    @JsxStaticFunction
    public static boolean supports() {
        return true;
    }

    @JsxStaticFunction
    public static String escape(String ident) {
        if (StringUtils.isEmptyOrNull(ident)) {
            return ident;
        }
        int length = ident.length();
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ident.charAt(i);
            if (c == '\u0000') {
                escaped.append('\ufffd');
                continue;
            }
            if ('\u0001' <= c && c <= '\u001f' || c == '\u007f') {
                escaped.append('\\').append(Integer.toHexString(c)).append(' ');
                continue;
            }
            if (i == 0 && '0' <= c && c <= '9') {
                escaped.append('\\').append(Integer.toHexString(c)).append(' ');
                continue;
            }
            if (i == 1 && '0' <= c && c <= '9' && ident.charAt(0) == '-') {
                escaped.append('\\').append(Integer.toHexString(c)).append(' ');
                continue;
            }
            if (i == 0 && c == '-' && length == 1) {
                escaped.append('\\').append(c);
                continue;
            }
            if (c >= '\u0080' || c == '-' || c == '_' || '0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                escaped.append(c);
                continue;
            }
            escaped.append('\\').append(c);
        }
        return escaped.toString();
    }
}

