/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass
public class StyleSheet
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(StyleSheet.class);
    private final HTMLElement ownerNode_;

    public StyleSheet() {
        this.ownerNode_ = null;
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public StyleSheet(HTMLElement ownerNode) {
        this.ownerNode_ = ownerNode;
    }

    @JsxGetter
    public HTMLElement getOwnerNode() {
        return this.ownerNode_;
    }

    @JsxGetter
    public String getHref() {
        if (this.ownerNode_ != null) {
            HtmlElement node = this.ownerNode_.getDomNodeOrDie();
            if (node instanceof HtmlStyle) {
                return null;
            }
            if (node instanceof HtmlLink) {
                HtmlLink link = (HtmlLink)node;
                String href = link.getHrefAttribute();
                try {
                    HtmlPage page = (HtmlPage)link.getPage();
                    URL url = page.getFullyQualifiedUrl(href);
                    return url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    LOG.warn(e.getMessage(), e);
                }
            }
        }
        return this.getUri();
    }

    public String getUri() {
        return null;
    }
}

