/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLLinkElement;
import org.htmlunit.javascript.host.html.HTMLStyleElement;

@JsxClass
public class StyleSheetList
extends HtmlUnitScriptable {
    private HTMLCollection nodes_;

    public StyleSheetList() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public StyleSheetList(Document document) {
        this.setParentScope(document);
        this.setPrototype(this.getPrototype(this.getClass()));
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        if (webClient.getOptions().isCssEnabled()) {
            this.nodes_ = new HTMLCollection(document.getDomNodeOrDie(), true);
            this.nodes_.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
                HtmlElement node = event.getHtmlElement();
                if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            });
            this.nodes_.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> {
                if (node instanceof HtmlStyle) {
                    return true;
                }
                if (node instanceof HtmlLink) {
                    return ((HtmlLink)node).isActiveStyleSheetLink();
                }
                return false;
            });
        } else {
            this.nodes_ = HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
    }

    @JsxGetter
    public int getLength() {
        return this.nodes_.getLength();
    }

    @JsxFunction
    public Object item(int index) {
        Object item = this.get(index, (Scriptable)this);
        if (JavaScriptEngine.UNDEFINED == item) {
            return null;
        }
        return item;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this == start) {
            if (this.nodes_ == null || index < 0 || index >= this.nodes_.getLength()) {
                return JavaScriptEngine.UNDEFINED;
            }
            HTMLElement element = (HTMLElement)this.nodes_.item(index);
            if (element instanceof HTMLStyleElement) {
                return ((HTMLStyleElement)element).getSheet();
            }
            return ((HTMLLinkElement)element).getSheet();
        }
        return super.get(index, start);
    }

    @Override
    protected Object equivalentValues(Object value) {
        return value != null && this.getClass() == value.getClass() && this.getDomNodeOrNull() == ((StyleSheetList)value).getDomNodeOrNull();
    }
}

