/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.Arrays;
import java.util.List;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;

@JsxClass
public class DOMException
extends HtmlUnitScriptable {
    @JsxConstant
    public static final int DOMSTRING_SIZE_ERR = 2;
    @JsxConstant
    public static final int HIERARCHY_REQUEST_ERR = 3;
    @JsxConstant
    public static final int INDEX_SIZE_ERR = 1;
    @JsxConstant
    public static final int INUSE_ATTRIBUTE_ERR = 10;
    @JsxConstant
    public static final int INVALID_ACCESS_ERR = 15;
    @JsxConstant
    public static final int INVALID_CHARACTER_ERR = 5;
    @JsxConstant
    public static final int INVALID_MODIFICATION_ERR = 13;
    @JsxConstant
    public static final int INVALID_STATE_ERR = 11;
    @JsxConstant
    public static final int NAMESPACE_ERR = 14;
    @JsxConstant
    public static final int NO_DATA_ALLOWED_ERR = 6;
    @JsxConstant
    public static final int NO_MODIFICATION_ALLOWED_ERR = 7;
    @JsxConstant
    public static final int NOT_FOUND_ERR = 8;
    @JsxConstant
    public static final int NOT_SUPPORTED_ERR = 9;
    @JsxConstant
    public static final int SYNTAX_ERR = 12;
    @JsxConstant
    public static final int WRONG_DOCUMENT_ERR = 4;
    @JsxConstant
    public static final int VALIDATION_ERR = 16;
    @JsxConstant
    public static final int TYPE_MISMATCH_ERR = 17;
    @JsxConstant
    public static final int SECURITY_ERR = 18;
    @JsxConstant
    public static final int NETWORK_ERR = 19;
    @JsxConstant
    public static final int ABORT_ERR = 20;
    @JsxConstant
    public static final int URL_MISMATCH_ERR = 21;
    @JsxConstant
    public static final int QUOTA_EXCEEDED_ERR = 22;
    @JsxConstant
    public static final int TIMEOUT_ERR = 23;
    @JsxConstant
    public static final int INVALID_NODE_TYPE_ERR = 24;
    @JsxConstant
    public static final int DATA_CLONE_ERR = 25;
    private static final List<String> COMMON_ERROR_NAMES = Arrays.asList("IndexSizeError", null, "HierarchyRequestError", "WrongDocumentError", "InvalidCharacterError", null, "NoModificationAllowedError", "NotFoundError", "NotSupportedError", "InUseAttributeError", "InvalidStateError", "SyntaxError", "InvalidModificationError", "NamespaceError", "InvalidAccessError", null, "TypeMismatchError", "SecurityError", "NetworkError", "AbortError", "URLMismatchError", "QuotaExceededError", "TimeoutError", "InvalidNodeTypeError", "DataCloneError");
    private int code_;
    private String name_;
    private String message_;
    private int lineNumber_;
    private String fileName_;

    public DOMException() {
    }

    public DOMException(String message, int error) {
        this.message_ = message;
        this.code_ = error;
        this.name_ = COMMON_ERROR_NAMES.get(error - 1);
    }

    @JsxConstructor
    public void jsConstructor(String message, Object error) {
        this.message_ = message;
        if (error == null) {
            this.code_ = 0;
            this.name_ = null;
            return;
        }
        if (JavaScriptEngine.isUndefined(error)) {
            this.code_ = 0;
            this.name_ = "Error";
            return;
        }
        this.name_ = JavaScriptEngine.toString(error);
        int idx = COMMON_ERROR_NAMES.indexOf(this.name_);
        if (idx != -1) {
            this.code_ = idx + 1;
            return;
        }
        this.code_ = 0;
    }

    @JsxGetter
    public Object getCode() {
        if (this.code_ == -1) {
            return JavaScriptEngine.UNDEFINED;
        }
        return this.code_;
    }

    @JsxGetter
    public String getName() {
        return this.name_;
    }

    @JsxGetter
    public Object getMessage() {
        if (this.message_ == null) {
            return JavaScriptEngine.UNDEFINED;
        }
        return this.message_;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getLineNumber() {
        if (this.lineNumber_ == -1) {
            return JavaScriptEngine.UNDEFINED;
        }
        return this.lineNumber_;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getFilename() {
        if (this.fileName_ == null) {
            return JavaScriptEngine.UNDEFINED;
        }
        return this.fileName_;
    }

    public void setLocation(String fileName, int lineNumber) {
        this.fileName_ = fileName;
        this.lineNumber_ = lineNumber;
    }
}

