/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.Window;

@JsxClass
public class DOMPointReadOnly
extends HtmlUnitScriptable {
    private double xVal_;
    private double yVal_;
    private double zVal_;
    private double wVal_;

    public DOMPointReadOnly() {
        this.wVal_ = 1.0;
    }

    public DOMPointReadOnly(double x, double y, double z, double w) {
        this.xVal_ = x;
        this.yVal_ = y;
        this.zVal_ = z;
        this.wVal_ = w;
    }

    @JsxConstructor
    public static DOMPointReadOnly jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        DOMPointReadOnly point = new DOMPointReadOnly(0.0, 0.0, 0.0, 1.0);
        point.init(args, ctorObj);
        return point;
    }

    protected void init(Object[] args, Function ctorObj) {
        Window window = DOMPointReadOnly.getWindow(ctorObj);
        this.setParentScope(window);
        this.setPrototype(((FunctionObject)ctorObj).getClassPrototype());
        if (args.length == 0 || JavaScriptEngine.isUndefined(args[0])) {
            return;
        }
        if (args.length > 0) {
            this.xVal_ = JavaScriptEngine.toNumber(args[0]);
        }
        if (args.length > 1) {
            this.yVal_ = JavaScriptEngine.toNumber(args[1]);
        }
        if (args.length > 2) {
            this.zVal_ = JavaScriptEngine.toNumber(args[2]);
        }
        if (args.length > 3) {
            this.wVal_ = JavaScriptEngine.toNumber(args[3]);
        }
    }

    @JsxGetter
    public double getX() {
        return this.xVal_;
    }

    public void setX(double x) {
        this.xVal_ = x;
    }

    @JsxGetter
    public double getY() {
        return this.yVal_;
    }

    public void setY(double y) {
        this.yVal_ = y;
    }

    @JsxGetter
    public double getZ() {
        return this.zVal_;
    }

    public void setZ(double z) {
        this.zVal_ = z;
    }

    @JsxGetter
    public double getW() {
        return this.wVal_;
    }

    public void setW(double w) {
        this.wVal_ = w;
    }

    @JsxFunction
    public Scriptable toJSON() {
        Scriptable json = JavaScriptEngine.newObject(this.getParentScope());
        json.put("x", json, (Object)this.xVal_);
        json.put("y", json, (Object)this.yVal_);
        json.put("z", json, (Object)this.zVal_);
        json.put("w", json, (Object)this.wVal_);
        return json;
    }
}

