/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.FunctionObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.Window;

@JsxClass
public class DOMRectReadOnly
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(DOMRectReadOnly.class);
    private double xVal_;
    private double yVal_;
    private double width_;
    private double height_;

    public DOMRectReadOnly() {
    }

    public DOMRectReadOnly(int x, int y, int width, int height) {
        this.xVal_ = x;
        this.yVal_ = y;
        this.width_ = width;
        this.height_ = height;
    }

    @JsxConstructor
    public static DOMRectReadOnly jsConstructor(Context cx, Scriptable scope, Object[] args, Function ctorObj, boolean inNewExpr) {
        DOMRectReadOnly rect = new DOMRectReadOnly(0, 0, 0, 0);
        rect.init(args, ctorObj);
        return rect;
    }

    protected void init(Object[] args, Function ctorObj) {
        Window window = DOMRectReadOnly.getWindow(ctorObj);
        this.setParentScope(window);
        this.setPrototype(((FunctionObject)ctorObj).getClassPrototype());
        if (args.length == 0 || JavaScriptEngine.isUndefined(args[0])) {
            return;
        }
        if (args.length > 0) {
            this.xVal_ = JavaScriptEngine.toNumber(args[0]);
        }
        if (args.length > 1) {
            this.yVal_ = JavaScriptEngine.toNumber(args[1]);
        }
        if (args.length > 2) {
            this.width_ = JavaScriptEngine.toNumber(args[2]);
        }
        if (args.length > 3) {
            this.height_ = JavaScriptEngine.toNumber(args[3]);
        }
    }

    @JsxGetter
    public double getX() {
        return this.xVal_;
    }

    public void setX(double x) {
        this.xVal_ = x;
    }

    @JsxGetter
    public double getY() {
        return this.yVal_;
    }

    public void setY(double y) {
        this.yVal_ = y;
    }

    @JsxGetter
    public double getWidth() {
        return this.width_;
    }

    public void setWidth(double width) {
        this.width_ = width;
    }

    @JsxGetter
    public double getHeight() {
        return this.height_;
    }

    public void setHeight(double height) {
        this.height_ = height;
    }

    @JsxGetter
    public double getTop() {
        return Math.min(this.getY(), this.getY() + this.getHeight());
    }

    @JsxGetter
    public double getRight() {
        return Math.max(this.getX(), this.getX() + this.getWidth());
    }

    @JsxGetter
    public double getBottom() {
        return Math.max(this.getY(), this.getY() + this.getHeight());
    }

    @JsxGetter
    public double getLeft() {
        return Math.min(this.getX(), this.getX() + this.getWidth());
    }

    @JsxFunction
    public Scriptable toJSON() {
        Scriptable json = JavaScriptEngine.newObject(this.getParentScope());
        json.put("x", json, (Object)this.xVal_);
        json.put("y", json, (Object)this.yVal_);
        json.put("width", json, (Object)this.width_);
        json.put("height", json, (Object)this.height_);
        json.put("top", json, (Object)this.getTop());
        json.put("right", json, (Object)this.getRight());
        json.put("bottom", json, (Object)this.getBottom());
        json.put("left", json, (Object)this.getLeft());
        return json;
    }
}

