/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLCollection;

@JsxClass(domClass=DomDocumentFragment.class)
public class DocumentFragment
extends Node {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        DomDocumentFragment fragment = new DomDocumentFragment(page);
        this.setDomNode(fragment);
    }

    @JsxFunction
    public static void append(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.append(context, thisObj, args, function);
    }

    @JsxFunction
    public static void prepend(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.prepend(context, thisObj, args, function);
    }

    @JsxFunction
    public static void replaceChildren(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.replaceChildren(context, thisObj, args, function);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF})
    public static void moveBefore(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        Node.moveBefore(context, scope, thisObj, args, function);
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw JavaScriptEngine.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw JavaScriptEngine.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    @Override
    @JsxGetter
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    @JsxGetter
    public Element getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    @JsxGetter
    public Element getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    @JsxGetter
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxFunction
    public HtmlUnitScriptable getElementById(Object id) {
        if (id == null || JavaScriptEngine.isUndefined(id)) {
            return null;
        }
        String idString = JavaScriptEngine.toString(id);
        if (idString == null || idString.length() == 0) {
            return null;
        }
        for (DomNode child : this.getDomNodeOrDie().getChildren()) {
            Element elem = (Element)child.getScriptableObject();
            if (!idString.equals(elem.getId())) continue;
            return elem;
        }
        return null;
    }

    @Override
    public Node getRootNode() {
        return this;
    }
}

