/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.AbstractList;

@JsxClass
public class NodeList
extends AbstractList
implements Callable {
    public NodeList() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public NodeList(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive, null);
    }

    public NodeList(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, true, new ArrayList<DomNode>(initialElements));
    }

    NodeList(ScriptableObject parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.setExternalArrayData(this);
    }

    public static NodeList staticNodeList(HtmlUnitScriptable parentScope, final List<DomNode> elements) {
        return new NodeList(parentScope){

            @Override
            public List<DomNode> getElements() {
                return elements;
            }
        };
    }

    @JsxFunction
    public Scriptable keys() {
        return JavaScriptEngine.newArrayIteratorTypeKeys(this.getParentScope(), this);
    }

    @JsxFunction
    @JsxSymbol(symbolName="iterator")
    public Scriptable values() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), this);
    }

    @JsxFunction
    public Scriptable entries() {
        return JavaScriptEngine.newArrayIteratorTypeEntries(this.getParentScope(), this);
    }

    @JsxFunction
    public void forEach(Object callback) {
        if (!(callback instanceof Function)) {
            throw JavaScriptEngine.typeError("Foreach callback '" + JavaScriptEngine.toString(callback) + "' is not a function");
        }
        if (this.getElements().isEmpty()) {
            return;
        }
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
        ContextAction<Object> contextAction = cx -> {
            Function function = (Function)callback;
            Scriptable scope = this.getParentScope();
            List<DomNode> nodes = this.getElements();
            int size = nodes.size();
            for (int i = 0; i < size && i < nodes.size(); ++i) {
                function.call(cx, scope, this, new Object[]{nodes.get(i).getScriptableObject(), i, this});
                nodes = this.getElements();
            }
            return null;
        };
        cf.call(contextAction);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return super.getLength();
    }

    @JsxFunction
    public Object item(Object index) {
        Object object = this.getIt(index);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw JavaScriptEngine.reportRuntimeError("Zero arguments; need an index or a key.");
        }
        Object object = this.getIt(args[0]);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @Override
    protected AbstractList create(DomNode parentScope, List<DomNode> initialElements) {
        return new NodeList(parentScope, new ArrayList<DomNode>(initialElements));
    }
}

