/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.file;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.NativeArray;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.file.Blob;
import org.htmlunit.util.KeyDataPair;

@JsxClass
public class File
extends Blob {
    private static final DateTimeFormatter LAST_MODIFIED_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z");

    public File() {
    }

    @JsxConstructor
    public void jsConstructor(NativeArray fileBits, String fileName, ScriptableObject properties) {
        if (fileBits == null || JavaScriptEngine.isUndefined(fileBits) || fileName == null || JavaScriptEngine.isUndefined(fileName)) {
            throw JavaScriptEngine.typeError("Failed to construct 'File': 2 arguments required.");
        }
        this.setBackend(Blob.InMemoryBackend.create(fileBits, fileName, File.extractFileTypeOrDefault(properties), File.extractLastModifiedOrDefault(properties)));
    }

    File(String pathname) {
        this.setBackend(new FileBackend(pathname));
    }

    @JsxGetter
    public String getName() {
        return this.getBackend().getName();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public String getLastModifiedDate() {
        Context cx = Context.getCurrentContext();
        ZoneId zoneid = cx.getTimeZone().toZoneId();
        String date = LAST_MODIFIED_DATE_FORMATTER.format(Instant.ofEpochMilli(this.getLastModified()).atZone(zoneid));
        date = date + DateTimeFormatter.ofPattern(" (zzzz)", cx.getLocale()).format(Instant.ofEpochMilli(this.getLastModified()).atZone(zoneid));
        return date;
    }

    @JsxGetter
    public long getLastModified() {
        return this.getBackend().getLastModified();
    }

    @JsxGetter
    public String getWebkitRelativePath() {
        return "";
    }

    @JsxFunction
    public void slice() {
    }

    private static class FileBackend
    extends Blob.Backend {
        private static final Log LOG = LogFactory.getLog(FileBackend.class);
        private final java.io.File file_;

        FileBackend(String pathname) {
            this.file_ = new java.io.File(pathname);
        }

        @Override
        public String getName() {
            return this.file_.getName();
        }

        @Override
        public long getLastModified() {
            return this.file_.lastModified();
        }

        @Override
        public long getSize() {
            return this.file_.length();
        }

        @Override
        public String getType(BrowserVersion browserVersion) {
            return browserVersion.getUploadMimeType(this.file_);
        }

        @Override
        public String getText() throws IOException {
            return FileUtils.readFileToString(this.file_, StandardCharsets.UTF_8);
        }

        @Override
        byte[] getBytes(int start, int end) {
            byte[] result = new byte[end - start];
            try {
                System.arraycopy(FileUtils.readFileToByteArray(this.file_), start, result, 0, result.length);
            }
            catch (IOException e) {
                LOG.error("FileBackend.getBytes failed", e);
            }
            return result;
        }

        @Override
        public KeyDataPair getKeyDataPair(String name, String fileName, String contentType) {
            return new KeyDataPair(name, this.file_, fileName, contentType, (Charset)null);
        }
    }
}

