/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlFrame;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.WindowProxy;
import org.htmlunit.javascript.host.html.DocumentProxy;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlFrame.class)
public class HTMLFrameElement
extends HTMLElement {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getSrc() {
        return this.getFrame().getSrcAttribute();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getFrame().setSrcAttribute(src);
    }

    @JsxGetter
    public DocumentProxy getContentDocument() {
        FrameWindow frameWindow = this.getFrame().getEnclosedWindow();
        if (FrameWindow.PageDenied.NONE != frameWindow.getPageDenied()) {
            return null;
        }
        return ((Window)frameWindow.getScriptableObject()).getDocument_js();
    }

    @JsxGetter
    public WindowProxy getContentWindow() {
        return Window.getProxy(this.getFrame().getEnclosedWindow());
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getFrame().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getFrame().setNameAttribute(name);
    }

    private BaseFrameElement getFrame() {
        return (BaseFrameElement)this.getDomNodeOrDie();
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

