/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.util.List;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.HTMLOptionElement;
import org.htmlunit.javascript.host.html.HTMLOptionsCollection;
import org.htmlunit.javascript.host.html.LabelsNodeList;
import org.htmlunit.javascript.host.html.ValidityState;

@JsxClass(domClass=HtmlSelect.class)
public class HTMLSelectElement
extends HTMLElement {
    private HTMLOptionsCollection optionsArray_;
    private NodeList labels_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    public void initialize() {
        HtmlSelect htmlSelect = this.getDomNodeOrDie();
        htmlSelect.setScriptableObject(this);
        if (this.optionsArray_ == null) {
            this.optionsArray_ = new HTMLOptionsCollection(this);
            this.optionsArray_.initialize(htmlSelect);
        }
    }

    @Override
    public HtmlSelect getDomNodeOrDie() {
        return (HtmlSelect)super.getDomNodeOrDie();
    }

    @JsxFunction
    public void remove(int index) {
        if (index < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_REMOVE_IGNORE_IF_INDEX_OUTSIDE)) {
            return;
        }
        HTMLOptionsCollection options = this.getOptions();
        if (index >= options.getLength() && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_REMOVE_IGNORE_IF_INDEX_OUTSIDE)) {
            return;
        }
        this.getOptions().remove(index);
    }

    @JsxFunction
    public void add(HTMLOptionElement newOptionObject, Object beforeOptionObject) {
        this.getOptions().add(newOptionObject, beforeOptionObject);
    }

    @Override
    public Node appendChild(Object childObject) {
        Node node = super.appendChild(childObject);
        this.getDomNodeOrDie().ensureSelectedIndex();
        return node;
    }

    @Override
    public Node insertBeforeImpl(Object[] args) {
        Node node = super.insertBeforeImpl(args);
        this.getDomNodeOrDie().ensureSelectedIndex();
        return node;
    }

    @JsxFunction
    public Object item(int index) {
        Object option = this.getOptions().item(index);
        if (JavaScriptEngine.isUndefined(option)) {
            return null;
        }
        return option;
    }

    @JsxGetter
    public String getType() {
        String type = this.getDomNodeOrDie().isMultipleSelectEnabled() ? "select-multiple" : "select-one";
        return type;
    }

    @JsxGetter
    public HTMLOptionsCollection getOptions() {
        if (this.optionsArray_ == null) {
            this.initialize();
        }
        return this.optionsArray_;
    }

    @JsxGetter
    public int getSelectedIndex() {
        return this.getDomNodeOrDie().getSelectedIndex();
    }

    @JsxSetter
    public void setSelectedIndex(int index) {
        this.getDomNodeOrDie().setSelectedIndex(index);
    }

    @Override
    @JsxGetter
    public String getValue() {
        List<HtmlOption> selectedOptions = this.getDomNodeOrDie().getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return "";
        }
        return ((HTMLOptionElement)selectedOptions.get(0).getScriptableObject()).getValue();
    }

    @JsxGetter
    public int getLength() {
        return this.getOptions().getLength();
    }

    @JsxSetter
    public void setLength(int newLength) {
        this.getOptions().setLength(newLength);
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.getOptions().get(index, start);
    }

    @Override
    public void put(int index, Scriptable start, Object newValue) {
        this.getOptions().put(index, start, newValue);
    }

    @Override
    @JsxSetter
    public void setValue(Object newValue) {
        String val = JavaScriptEngine.toString(newValue);
        this.getDomNodeOrDie().setSelectedAttribute(val, true, false);
    }

    @JsxGetter
    public int getSize() {
        return this.getDomNodeOrDie().getSize();
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setAttribute("size", size);
    }

    @JsxGetter
    public boolean isMultiple() {
        return this.getDomNodeOrDie().hasAttribute("multiple");
    }

    @JsxSetter
    public void setMultiple(boolean multiple) {
        if (multiple) {
            this.getDomNodeOrDie().setAttribute("multiple", "multiple");
        } else {
            this.getDomNodeOrDie().removeAttribute("multiple");
        }
    }

    @JsxGetter
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }

    @JsxGetter
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @Override
    @JsxGetter
    public String getName() {
        return super.getName();
    }

    @Override
    @JsxSetter
    public void setName(String newName) {
        super.setName(newName);
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return super.isDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        return super.getForm();
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxGetter
    public boolean isWillValidate() {
        return this.getDomNodeOrDie().willValidate();
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        this.getDomNodeOrDie().setCustomValidity(message);
    }

    @JsxSymbol
    public Scriptable iterator() {
        return this.getOptions().iterator();
    }
}

