/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlSpan;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.util.StringUtils;

@JsxClass(domClass=HtmlSpan.class)
public class HTMLSpanElement
extends HTMLElement {
    private boolean endTagForbidden_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.endTagForbidden_ = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLBASEFONT_END_TAG_FORBIDDEN) && "basefont".equals(StringUtils.toRootLowerCase(domNode.getLocalName()));
    }

    public String getCite() {
        return this.getDomNodeOrDie().getAttributeDirect("cite");
    }

    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    public String getDateTime() {
        return this.getDomNodeOrDie().getAttributeDirect("datetime");
    }

    public void setDateTime(String dateTime) {
        this.getDomNodeOrDie().setAttribute("datetime", dateTime);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }
}

