/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlStyle.class)
public class HTMLStyleElement
extends HTMLElement {
    private CSSStyleSheet sheet_;

    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public CSSStyleSheet getSheet() {
        if (this.sheet_ != null) {
            return this.sheet_;
        }
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        this.sheet_ = new CSSStyleSheet((HTMLElement)this, this.getWindow(), style.getSheet());
        return this.sheet_;
    }

    @JsxGetter
    public String getType() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getTypeAttribute();
    }

    @JsxSetter
    public void setType(String type) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setTypeAttribute(type);
    }

    @JsxGetter
    public String getMedia() {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        return style.getAttributeDirect("media");
    }

    @JsxSetter
    public void setMedia(String media) {
        HtmlStyle style = (HtmlStyle)this.getDomNodeOrDie();
        style.setAttribute("media", media);
    }

    @Override
    @JsxGetter
    public boolean isDisabled() {
        return !this.getSheet().getCssStyleSheet().isEnabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        CssStyleSheet sheet = this.getSheet().getCssStyleSheet();
        boolean modified = disabled == sheet.isEnabled();
        sheet.setEnabled(!disabled);
        if (modified) {
            this.getDomNodeOrDie().getPage().clearComputedStyles();
        }
    }
}

