/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.platform.font;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import org.htmlunit.css.CssPixelValueConverter;
import org.htmlunit.platform.font.FontUtil;
import org.htmlunit.util.StringUtils;

public class AwtFontUtil
implements FontUtil {
    @Override
    public int countLines(String content, int pixelWidth, String fontSize) {
        String[] lines = org.apache.commons.lang3.StringUtils.split(content, '\n');
        int lineCount = 0;
        int fontSizeInt = CssPixelValueConverter.pixelValue(fontSize);
        FontRenderContext fontRenderCtx = new FontRenderContext(null, false, true);
        for (String line : lines) {
            if (StringUtils.isBlank(line)) {
                ++lineCount;
                continue;
            }
            AttributedString attributedString = new AttributedString(line);
            attributedString.addAttribute(TextAttribute.SIZE, (double)fontSizeInt / 1.1);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), fontRenderCtx);
            do {
                lineBreakMeasurer.nextLayout(pixelWidth);
            } while (lineBreakMeasurer.getPosition() < line.length() && ++lineCount < 1000);
        }
        return lineCount;
    }
}

