/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

public final class ArrayUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private ArrayUtils() {
    }

    public static boolean contains(String[] strings, String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Expected string can't be null");
        }
        if (strings == null) {
            return false;
        }
        for (String s : strings) {
            if (!expected.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] chars, char expected) {
        if (chars == null) {
            return false;
        }
        for (char c : chars) {
            if (expected != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] bytes, byte expected) {
        if (bytes == null) {
            return false;
        }
        for (byte b : bytes) {
            if (expected != b) continue;
            return true;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] strings, String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("Expected string can't be null");
        }
        if (strings == null) {
            return false;
        }
        for (String s : strings) {
            if (!expected.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }
}

