/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public final class XUserDefinedCharset
extends Charset {
    public static final String NAME = "x-user-defined";
    public static final XUserDefinedCharset INSTANCE = new XUserDefinedCharset();

    private XUserDefinedCharset() {
        super(NAME, new String[0]);
    }

    @Override
    public boolean contains(Charset charset) {
        return StandardCharsets.US_ASCII.equals(charset);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new XUserDefinedDecoder();
    }

    @Override
    public CharsetEncoder newEncoder() {
        return null;
    }

    private static final class XUserDefinedDecoder
    extends CharsetDecoder {
        XUserDefinedDecoder() {
            super(INSTANCE, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                if (b >= 0) {
                    out.append((char)b);
                    continue;
                }
                out.append((char)(63232 + (b & 0xFF)));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

