/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomProcessingInstruction;
import org.htmlunit.util.XmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlPage
extends SgmlPage {
    private static final Log LOG = LogFactory.getLog(XmlPage.class);
    private Node node_;

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow) throws IOException {
        this(webResponse, enclosingWindow, true);
    }

    public XmlPage(Node node, WebWindow enclosingWindow) {
        super(null, enclosingWindow);
        this.node_ = node;
        if (this.node_ != null) {
            XmlUtils.appendChild(this, this, this.node_, true);
        }
    }

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow, boolean ignoreSAXException) throws IOException {
        this(webResponse, enclosingWindow, ignoreSAXException, true);
    }

    public XmlPage(WebResponse webResponse, WebWindow enclosingWindow, boolean ignoreSAXException, boolean handleXHTMLAsHTML) throws IOException {
        block8: {
            super(webResponse, enclosingWindow);
            try {
                try {
                    Document document = XmlUtils.buildDocument(webResponse);
                    this.node_ = document.getFirstChild();
                }
                catch (SAXException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Failed parsing XML document '" + webResponse.getWebRequest().getUrl() + "'", e);
                    }
                    if (!ignoreSAXException) {
                        throw new IOException("Failed parsing XML document '" + webResponse.getWebRequest().getUrl() + "'", e);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                if (!LOG.isWarnEnabled()) break block8;
                if (null == webResponse) {
                    LOG.warn("Failed parsing XML empty document: " + e.getMessage(), e);
                }
                LOG.warn("Failed parsing XML empty document '" + webResponse.getWebRequest().getUrl() + "'", e);
            }
        }
        Map<Integer, List<String>> attributesOrderMap = this.node_ != null ? XmlUtils.getAttributesOrderMap(this.node_.getOwnerDocument()) : null;
        for (Node node = this.node_; node != null; node = node.getNextSibling()) {
            XmlUtils.appendChild(this, this, node, handleXHTMLAsHTML, attributesOrderMap);
        }
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean hasCaseSensitiveTagNames() {
        return true;
    }

    public Document getXmlDocument() {
        if (this.node_ != null) {
            return this.node_.getOwnerDocument();
        }
        return null;
    }

    @Override
    public Node adoptNode(Node source) {
        throw new UnsupportedOperationException("XmlPage.adoptNode is not yet implemented.");
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("XmlPage.createAttributeNS is not yet implemented.");
    }

    @Override
    public DomElement createElement(String tagName) {
        return this.createElementNS(null, tagName);
    }

    @Override
    public DomElement createElementNS(String namespaceURI, String qualifiedName) {
        return new DomElement(namespaceURI, qualifiedName, this, new HashMap<String, DomAttr>());
    }

    @Override
    public EntityReference createEntityReference(String name) {
        throw new UnsupportedOperationException("XmlPage.createEntityReference is not yet implemented.");
    }

    @Override
    public DomProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DomProcessingInstruction(this, target, data);
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("XmlPage.getDocumentURI is not yet implemented.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("XmlPage.getDomConfig is not yet implemented.");
    }

    @Override
    public Element getElementById(String elementId) {
        throw new UnsupportedOperationException("XmlPage.getElementById is not yet implemented.");
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("XmlPage.getImplementation is not yet implemented.");
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("XmlPage.getInputEncoding is not yet implemented.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("XmlPage.getStrictErrorChecking is not yet implemented.");
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) {
        throw new UnsupportedOperationException("XmlPage.importNode is not yet implemented.");
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("XmlPage.renameNode is not yet implemented.");
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("XmlPage.setDocumentURI is not yet implemented.");
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("XmlPage.setStrictErrorChecking is not yet implemented.");
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) {
        throw new UnsupportedOperationException("XmlPage.setXmlStandalone is not yet implemented.");
    }

    @Override
    public void setXmlVersion(String xmlVersion) {
        throw new UnsupportedOperationException("XmlPage.setXmlVersion is not yet implemented.");
    }

    @Override
    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public void setDocumentType(DocumentType type) {
        super.setDocumentType(type);
    }

    @Override
    public void setNodeValue(String value) {
    }

    @Override
    public void setPrefix(String prefix) {
    }
}

