/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.xml.dtm.ref;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.htmlunit.xpath.res.XPATHMessages;
import org.htmlunit.xpath.xml.dtm.DTM;
import org.htmlunit.xpath.xml.dtm.DTMManager;
import org.htmlunit.xpath.xml.dtm.ref.DTMNodeProxy;
import org.htmlunit.xpath.xml.dtm.ref.ExpandedNameTable;
import org.htmlunit.xpath.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.htmlunit.xpath.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class DTMManagerDefault
extends DTMManager {
    private static final boolean DEBUG = false;
    protected DTM[] m_dtms = new DTM[256];
    int[] m_dtm_offsets = new int[256];
    private final ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();

    public synchronized void addDTM(DTM dtm, int id, int offset) {
        if (id >= 65536) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NO_DTMIDS_AVAIL", null));
        }
        int oldlen = this.m_dtms.length;
        if (oldlen <= id) {
            int newlen = Math.min(id + 256, 65536);
            DTM[] newDtms = new DTM[newlen];
            System.arraycopy(this.m_dtms, 0, newDtms, 0, oldlen);
            this.m_dtms = newDtms;
            int[] newDtmOffsets = new int[newlen];
            System.arraycopy(this.m_dtm_offsets, 0, newDtmOffsets, 0, oldlen);
            this.m_dtm_offsets = newDtmOffsets;
        }
        this.m_dtms[id] = dtm;
        this.m_dtm_offsets[id] = offset;
    }

    public synchronized int getFirstFreeDTMID() {
        int n = this.m_dtms.length;
        for (int i = 1; i < n; ++i) {
            if (null != this.m_dtms[i]) continue;
            return i;
        }
        return n;
    }

    @Override
    public synchronized DTM getDTM(Source source, boolean unique, boolean incremental, boolean doIndexing) {
        int dtmPos = this.getFirstFreeDTMID();
        int documentID = dtmPos << 16;
        if (null != source && source instanceof DOMSource) {
            DOM2DTM dtm = new DOM2DTM((DTMManager)this, (DOMSource)source, documentID, doIndexing);
            this.addDTM(dtm, dtmPos, 0);
            return dtm;
        }
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NOT_SUPPORTED", new Object[]{source}));
    }

    @Override
    public synchronized int getDTMHandleFromNode(Node node) {
        int handle;
        Node p;
        if (null == node) {
            throw new IllegalArgumentException(XPATHMessages.createXPATHMessage("ER_NODE_NON_NULL", null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        for (DTM thisDTM : this.m_dtms) {
            int handle2;
            if (null == thisDTM || !(thisDTM instanceof DOM2DTM) || (handle2 = ((DOM2DTM)thisDTM).getHandleOfNode(node)) == -1) continue;
            return handle2;
        }
        Node root = node;
        Node node2 = p = root.getNodeType() == 2 ? ((Attr)root).getOwnerElement() : root.getParentNode();
        while (p != null) {
            root = p;
            p = p.getParentNode();
        }
        DOM2DTM dtm = (DOM2DTM)this.getDTM(new DOMSource(root), false, true, true);
        if (node instanceof DOM2DTMdefaultNamespaceDeclarationNode) {
            handle = dtm.getHandleOfNode(((Attr)node).getOwnerElement());
            handle = dtm.getAttributeNode(handle, node.getNamespaceURI(), node.getLocalName());
        } else {
            handle = dtm.getHandleOfNode(node);
        }
        if (-1 == handle) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_COULD_NOT_RESOLVE_NODE", null));
        }
        return handle;
    }

    @Override
    public synchronized DTM getDTM(int nodeHandle) {
        try {
            return this.m_dtms[nodeHandle >>> 16];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (nodeHandle == -1) {
                return null;
            }
            throw e;
        }
    }

    public ExpandedNameTable getExpandedNameTable() {
        return this.m_expandedNameTable;
    }
}

