/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.xml.dtm.ref.dom2dtm;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.htmlunit.xpath.objects.XString;
import org.htmlunit.xpath.res.XPATHMessages;
import org.htmlunit.xpath.xml.dtm.DTMManager;
import org.htmlunit.xpath.xml.dtm.ref.DTMDefaultBaseIterators;
import org.htmlunit.xpath.xml.dtm.ref.DTMManagerDefault;
import org.htmlunit.xpath.xml.dtm.ref.ExpandedNameTable;
import org.htmlunit.xpath.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.htmlunit.xpath.xml.utils.XMLCharacterRecognizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOM2DTM
extends DTMDefaultBaseIterators {
    static final boolean JJK_DEBUG = false;
    static final String NAMESPACE_DECL_NS = "http://www.w3.org/XML/1998/namespace";
    private transient Node m_pos;
    private int m_last_parent;
    private int m_last_kid;
    private final transient Node m_root;
    boolean m_processedFirstElement = false;
    private transient boolean m_nodesAreProcessed;
    protected final List<Node> m_nodes = new ArrayList<Node>();

    public DOM2DTM(DTMManager mgr, DOMSource domSource, int dtmIdentity, boolean doIndexing) {
        super(mgr, domSource, dtmIdentity, doIndexing);
        this.m_pos = this.m_root = domSource.getNode();
        this.m_last_kid = -1;
        this.m_last_parent = -1;
        this.m_last_kid = this.addNode(this.m_root, this.m_last_parent, this.m_last_kid, -1);
        if (1 == this.m_root.getNodeType()) {
            int attrsize;
            NamedNodeMap attrs = this.m_root.getAttributes();
            int n = attrsize = attrs == null ? 0 : attrs.getLength();
            if (attrsize > 0) {
                int attrIndex = -1;
                for (int i = 0; i < attrsize; ++i) {
                    attrIndex = this.addNode(attrs.item(i), 0, attrIndex, -1);
                    this.m_firstch.setElementAt(-1, attrIndex);
                }
                this.m_nextsib.setElementAt(-1, attrIndex);
            }
        }
        this.m_nodesAreProcessed = false;
    }

    protected int addNode(Node node, int parentIndex, int previousSibling, int forceNodeType) {
        String localName;
        String name;
        int nodeIndex = this.m_nodes.size();
        if (this.m_dtmIdent.size() == nodeIndex >>> 16) {
            try {
                if (this.m_mgr == null) {
                    throw new ClassCastException();
                }
                DTMManagerDefault mgrD = (DTMManagerDefault)this.m_mgr;
                int id = mgrD.getFirstFreeDTMID();
                mgrD.addDTM(this, id, nodeIndex);
                this.m_dtmIdent.addElement(id << 16);
            }
            catch (ClassCastException e) {
                throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NO_DTMIDS_AVAIL", null), e);
            }
        }
        ++this.m_size;
        int type = -1 == forceNodeType ? (int)node.getNodeType() : forceNodeType;
        if (2 == type && ((name = node.getNodeName()).startsWith("xmlns:") || "xmlns".equals(name))) {
            type = 13;
        }
        this.m_nodes.add(node);
        this.m_firstch.setElementAt(-2, nodeIndex);
        this.m_nextsib.setElementAt(-2, nodeIndex);
        this.m_prevsib.setElementAt(previousSibling, nodeIndex);
        this.m_parent.setElementAt(parentIndex, nodeIndex);
        if (-1 != parentIndex && type != 2 && type != 13 && -2 == this.m_firstch.elementAt(parentIndex)) {
            this.m_firstch.setElementAt(nodeIndex, parentIndex);
        }
        String nsURI = node.getNamespaceURI();
        String string = localName = type == 7 ? node.getNodeName() : node.getLocalName();
        if ((type == 1 || type == 2) && null == localName) {
            localName = node.getNodeName();
        }
        ExpandedNameTable exnt = this.m_expandedNameTable;
        if (node.getLocalName() != null || type == 1 || type == 2) {
            // empty if block
        }
        int expandedNameID = null != localName ? exnt.getExpandedTypeID(nsURI, localName, type) : type;
        this.m_exptype.setElementAt(expandedNameID, nodeIndex);
        this.indexNode(expandedNameID, nodeIndex);
        if (-1 != previousSibling) {
            this.m_nextsib.setElementAt(nodeIndex, previousSibling);
        }
        if (type == 13) {
            this.declareNamespaceInContext(parentIndex, nodeIndex);
        }
        return nodeIndex;
    }

    @Override
    protected boolean nextNode() {
        if (this.m_nodesAreProcessed) {
            return false;
        }
        Node pos = this.m_pos;
        Node next = null;
        int nexttype = -1;
        do {
            if (pos.hasChildNodes()) {
                next = pos.getFirstChild();
                if (next != null && 10 == next.getNodeType()) {
                    next = next.getNextSibling();
                }
                if (5 != pos.getNodeType()) {
                    this.m_last_parent = this.m_last_kid;
                    this.m_last_kid = -1;
                }
            } else {
                if (this.m_last_kid != -1 && this.m_firstch.elementAt(this.m_last_kid) == -2) {
                    this.m_firstch.setElementAt(-1, this.m_last_kid);
                }
                while (this.m_last_parent != -1) {
                    next = pos.getNextSibling();
                    if (next != null && 10 == next.getNodeType()) {
                        next = next.getNextSibling();
                    }
                    if (next != null) break;
                    if ((pos = pos.getParentNode()) == null) {
                        // empty if block
                    }
                    if (pos != null && 5 == pos.getNodeType()) continue;
                    if (this.m_last_kid == -1) {
                        this.m_firstch.setElementAt(-1, this.m_last_parent);
                    } else {
                        this.m_nextsib.setElementAt(-1, this.m_last_kid);
                    }
                    this.m_last_kid = this.m_last_parent;
                    this.m_last_parent = this.m_parent.elementAt(this.m_last_kid);
                }
                if (this.m_last_parent == -1) {
                    next = null;
                }
            }
            if (next != null) {
                nexttype = next.getNodeType();
            }
            if (5 != nexttype) continue;
            pos = next;
        } while (5 == nexttype);
        if (next == null) {
            this.m_nextsib.setElementAt(-1, 0);
            this.m_nodesAreProcessed = true;
            this.m_pos = null;
            return false;
        }
        boolean suppressNode = false;
        Node lastTextNode = null;
        nexttype = next.getNodeType();
        if (3 == nexttype || 4 == nexttype) {
            Node n = next;
            while (n != null) {
                lastTextNode = n;
                if (3 == n.getNodeType()) {
                    nexttype = 3;
                }
                suppressNode &= XMLCharacterRecognizer.isWhiteSpace(n.getNodeValue());
                n = this.logicalNextDOMTextNode(n);
            }
        } else if (7 == nexttype) {
            suppressNode = "xml".equalsIgnoreCase(pos.getNodeName());
        }
        if (!suppressNode) {
            int nextindex;
            this.m_last_kid = nextindex = this.addNode(next, this.m_last_parent, this.m_last_kid, nexttype);
            if (1 == nexttype) {
                int attrsize;
                int attrIndex = -1;
                NamedNodeMap attrs = next.getAttributes();
                int n = attrsize = attrs == null ? 0 : attrs.getLength();
                if (attrsize > 0) {
                    for (int i = 0; i < attrsize; ++i) {
                        attrIndex = this.addNode(attrs.item(i), nextindex, attrIndex, -1);
                        this.m_firstch.setElementAt(-1, attrIndex);
                        if (this.m_processedFirstElement || !"xmlns:xml".equals(attrs.item(i).getNodeName())) continue;
                        this.m_processedFirstElement = true;
                    }
                }
                if (!this.m_processedFirstElement) {
                    attrIndex = this.addNode(new DOM2DTMdefaultNamespaceDeclarationNode((Element)next, "xml", NAMESPACE_DECL_NS), nextindex, attrIndex, -1);
                    this.m_firstch.setElementAt(-1, attrIndex);
                    this.m_processedFirstElement = true;
                }
                if (attrIndex != -1) {
                    this.m_nextsib.setElementAt(-1, attrIndex);
                }
            }
        }
        if (3 == nexttype || 4 == nexttype) {
            next = lastTextNode;
        }
        this.m_pos = next;
        return true;
    }

    @Override
    public Node getNode(int nodeHandle) {
        int identity = this.makeNodeIdentity(nodeHandle);
        return this.m_nodes.get(identity);
    }

    protected Node lookupNode(int nodeIdentity) {
        return this.m_nodes.get(nodeIdentity);
    }

    @Override
    protected int getNextNodeIdentity(int identity) {
        if (++identity >= this.m_nodes.size() && !this.nextNode()) {
            identity = -1;
        }
        return identity;
    }

    private int getHandleFromNode(Node node) {
        if (null != node) {
            int len = this.m_nodes.size();
            int i = 0;
            while (true) {
                if (i < len) {
                    if (this.m_nodes.get(i) == node) {
                        return this.makeNodeHandle(i);
                    }
                    ++i;
                    continue;
                }
                boolean isMore = this.nextNode();
                len = this.m_nodes.size();
                if (!isMore && i >= len) break;
            }
        }
        return -1;
    }

    public int getHandleOfNode(Node node) {
        if (null != node && (this.m_root == node || this.m_root.getNodeType() == 9 && this.m_root == node.getOwnerDocument() || this.m_root.getNodeType() != 9 && this.m_root.getOwnerDocument() == node.getOwnerDocument())) {
            Node cursor = node;
            while (cursor != null) {
                if (cursor == this.m_root) {
                    return this.getHandleFromNode(node);
                }
                cursor = cursor.getNodeType() != 2 ? cursor.getParentNode() : ((Attr)cursor).getOwnerElement();
            }
        }
        return -1;
    }

    @Override
    public int getAttributeNode(int nodeHandle, String namespaceURI, String name) {
        short type;
        if (null == namespaceURI) {
            namespaceURI = "";
        }
        if (1 == (type = this.getNodeType(nodeHandle))) {
            int identity = this.makeNodeIdentity(nodeHandle);
            while (-1 != (identity = this.getNextNodeIdentity(identity)) && ((type = this._type(identity)) == 2 || type == 13)) {
                Node node = this.lookupNode(identity);
                String nodeuri = node.getNamespaceURI();
                if (null == nodeuri) {
                    nodeuri = "";
                }
                String nodelocalname = node.getLocalName();
                if (!nodeuri.equals(namespaceURI) || !name.equals(nodelocalname)) continue;
                return this.makeNodeHandle(identity);
            }
        }
        return -1;
    }

    @Override
    public XString getStringValue(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        Node node = this.getNode(nodeHandle);
        if (1 == type || 9 == type || 11 == type) {
            StringBuilder buf = new StringBuilder();
            DOM2DTM.getNodeData(node, buf);
            String s = buf.length() > 0 ? buf.toString() : "";
            return new XString(s);
        }
        if (3 == type || 4 == type) {
            StringBuilder buf = new StringBuilder();
            while (node != null) {
                buf.append(node.getNodeValue());
                node = this.logicalNextDOMTextNode(node);
            }
            String s = buf.length() > 0 ? buf.toString() : "";
            return new XString(s);
        }
        return new XString(node.getNodeValue());
    }

    protected static void getNodeData(Node node, StringBuilder buf) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                for (Node child = node.getFirstChild(); null != child; child = child.getNextSibling()) {
                    DOM2DTM.getNodeData(child, buf);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                buf.append(node.getNodeValue());
                break;
            }
            case 7: {
                break;
            }
        }
    }

    @Override
    public String getNodeName(int nodeHandle) {
        Node node = this.getNode(nodeHandle);
        return node.getNodeName();
    }

    @Override
    public String getNodeNameX(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        if (13 == type) {
            String namespaceNodeName = this.getNode(nodeHandle).getNodeName();
            if (namespaceNodeName.startsWith("xmlns:")) {
                return DOM2DTM.getLocalPart(namespaceNodeName);
            }
            if ("xmlns".equals(namespaceNodeName)) {
                return "";
            }
            return namespaceNodeName;
        }
        if (2 == type || 1 == type || 5 == type || 7 == type) {
            return this.getNode(nodeHandle).getNodeName();
        }
        return "";
    }

    private static String getLocalPart(String qname2) {
        int index = qname2.indexOf(58);
        return index < 0 ? qname2 : qname2.substring(index + 1);
    }

    @Override
    public String getLocalName(int nodeHandle) {
        int id = this.makeNodeIdentity(nodeHandle);
        if (-1 == id) {
            return null;
        }
        Node newnode = this.m_nodes.get(id);
        String newname = newnode.getLocalName();
        if (null == newname) {
            int index;
            String qname2 = newnode.getNodeName();
            newname = '#' == qname2.charAt(0) ? "" : ((index = qname2.indexOf(58)) < 0 ? qname2 : qname2.substring(index + 1));
        }
        return newname;
    }

    @Override
    public String getPrefix(int nodeHandle) {
        short type = this.getNodeType(nodeHandle);
        if (13 == type) {
            String qname2 = this.getNode(nodeHandle).getNodeName();
            int index = qname2.indexOf(58);
            return index < 0 ? "" : qname2.substring(index + 1);
        }
        if (2 == type || 1 == type) {
            String qname3 = this.getNode(nodeHandle).getNodeName();
            int index = qname3.indexOf(58);
            return index < 0 ? "" : qname3.substring(0, index);
        }
        return "";
    }

    @Override
    public String getNamespaceURI(int nodeHandle) {
        int id = this.makeNodeIdentity(nodeHandle);
        if (id == -1) {
            return null;
        }
        Node node = this.m_nodes.get(id);
        return node.getNamespaceURI();
    }

    private Node logicalNextDOMTextNode(Node n) {
        short ntype;
        Node p = n.getNextSibling();
        if (p == null) {
            for (n = n.getParentNode(); n != null && 5 == n.getNodeType() && (p = n.getNextSibling()) == null; n = n.getParentNode()) {
            }
        }
        n = p;
        while (n != null && 5 == n.getNodeType()) {
            if (n.hasChildNodes()) {
                n = n.getFirstChild();
                continue;
            }
            n = n.getNextSibling();
        }
        if (n != null && 3 != (ntype = n.getNodeType()) && 4 != ntype) {
            n = null;
        }
        return n;
    }

    @Override
    public String getNodeValue(int nodeHandle) {
        int type = this._exptype(this.makeNodeIdentity(nodeHandle));
        int n = type = -1 != type ? (int)this.getNodeType(nodeHandle) : -1;
        if (3 != type && 4 != type) {
            return this.getNode(nodeHandle).getNodeValue();
        }
        Node node = this.getNode(nodeHandle);
        Node n2 = this.logicalNextDOMTextNode(node);
        if (n2 == null) {
            return node.getNodeValue();
        }
        StringBuilder buf = new StringBuilder();
        buf.append(node.getNodeValue());
        while (n2 != null) {
            buf.append(n2.getNodeValue());
            n2 = this.logicalNextDOMTextNode(n2);
        }
        return buf.length() > 0 ? buf.toString() : "";
    }

    @Override
    public int getElementById(String elementId) {
        Element elem;
        Document doc;
        Document document = doc = this.m_root.getNodeType() == 9 ? (Document)this.m_root : this.m_root.getOwnerDocument();
        if (null != doc && null != (elem = doc.getElementById(elementId))) {
            int elemHandle = this.getHandleFromNode(elem);
            if (-1 == elemHandle) {
                int identity = this.m_nodes.size() - 1;
                while (-1 != (identity = this.getNextNodeIdentity(identity))) {
                    Node node = this.getNode(identity);
                    if (node != elem) continue;
                    elemHandle = this.getHandleFromNode(elem);
                    break;
                }
            }
            return elemHandle;
        }
        return -1;
    }
}

