/*
 * Decompiled with CFR 0.152.
 */
package org.wetator;

import java.io.File;
import java.util.LinkedList;
import javax.swing.JWindow;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wetator.Version;
import org.wetator.core.WetatorEngine;
import org.wetator.gui.DialogUtil;
import org.wetator.progresslistener.StdOutProgressListener;
import org.wetator.util.Log4jUtil;

public final class Wetator {
    private static final Logger LOG = LogManager.getLogger(Wetator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] anArgsArray) {
        String tmpConfigFileName = null;
        String tmpVariablesFileName = null;
        File tmpDebugLogFile = null;
        boolean tmpAppendResults = false;
        LinkedList<String> tmpFileNames = new LinkedList<String>();
        for (int i = 0; i < anArgsArray.length; ++i) {
            String tmpArg = anArgsArray[i].trim();
            if ("-log".equals(tmpArg)) {
                tmpDebugLogFile = new File("wetator.log");
                Log4jUtil.configureDebugLogging(tmpDebugLogFile);
                continue;
            }
            if ("-append".equals(tmpArg)) {
                tmpAppendResults = true;
                continue;
            }
            if ("-p".equals(tmpArg) && i < anArgsArray.length - 1) {
                tmpConfigFileName = anArgsArray[i + 1];
                ++i;
                continue;
            }
            if ("-var".equals(tmpArg) && i < anArgsArray.length - 1) {
                tmpVariablesFileName = anArgsArray[i + 1];
                ++i;
                continue;
            }
            tmpFileNames.add(tmpArg);
        }
        LOG.info(Version.getFullProductName());
        LOG.info("    " + org.htmlunit.Version.getProductName() + " " + "4.21.0");
        if (null != tmpDebugLogFile) {
            LOG.info("    Debug log file: " + FilenameUtils.normalize(tmpDebugLogFile.getAbsolutePath()));
        }
        StdOutProgressListener tmpProgressListener = new StdOutProgressListener();
        try {
            WetatorEngine tmpWetatorEngine = new WetatorEngine();
            try {
                tmpWetatorEngine.addProgressListener(tmpProgressListener);
                if (null != tmpConfigFileName) {
                    tmpWetatorEngine.setConfigFileName(tmpConfigFileName);
                }
                if (null != tmpVariablesFileName) {
                    tmpWetatorEngine.setVariablesFileName(tmpVariablesFileName);
                }
                tmpWetatorEngine.init();
                if (tmpAppendResults) {
                    if (tmpWetatorEngine.getConfiguration().isDistinctOutputEnabled()) {
                        System.out.println("Wetator execution failed because the 'append' command line flag can't be used togethere with the 'distinctOutput' setting.");
                        LOG.fatal("Wetator execution failed because the 'append' command line flag can't be used togethere with the 'distinctOutput' setting.");
                        System.exit(1);
                    }
                    tmpWetatorEngine.getConfiguration().enableAppendResults();
                }
                if (null != tmpDebugLogFile) {
                    tmpWetatorEngine.getConfiguration().enableDebugLogging();
                }
                if (tmpFileNames.isEmpty()) {
                    String tmpPropertyKey = null;
                    File tmpConfigFile = tmpWetatorEngine.getConfigFile();
                    if (null != tmpConfigFile) {
                        tmpPropertyKey = Integer.toString(tmpConfigFile.getAbsolutePath().hashCode());
                    }
                    JWindow tmpWindow = new JWindow();
                    try {
                        File[] tmpFiles = DialogUtil.chooseFiles(tmpWindow, tmpPropertyKey);
                        if (null == tmpFiles || tmpFiles.length < 1) {
                            System.exit(0);
                        }
                        for (File tmpFile : tmpFiles) {
                            tmpWetatorEngine.addTestCase(tmpFile.getName(), tmpFile);
                        }
                    }
                    finally {
                        tmpWindow.dispose();
                    }
                } else {
                    File tmpCurrentDir = new File(".");
                    for (String tmpFileName : tmpFileNames) {
                        WildcardFileFilter tmpFilter;
                        File[] tmpFiles;
                        File tmpSearchFile = new File(tmpFileName);
                        if (tmpSearchFile.isAbsolute()) {
                            tmpWetatorEngine.addTestCase(tmpFileName, tmpSearchFile);
                            continue;
                        }
                        tmpSearchFile = new File(tmpCurrentDir, tmpFileName);
                        if (tmpSearchFile.exists()) {
                            tmpWetatorEngine.addTestCase(tmpFileName, tmpSearchFile);
                            continue;
                        }
                        File tmpDir = tmpSearchFile.getParentFile();
                        if (tmpDir == null || !tmpDir.exists() || (tmpFiles = tmpDir.listFiles(tmpFilter = WildcardFileFilter.builder().setIoCase(IOCase.SENSITIVE).setWildcards(tmpSearchFile.getName()).get())) == null) continue;
                        for (File tmpFile : tmpFiles) {
                            tmpWetatorEngine.addTestCase(tmpFile.getName(), tmpFile);
                        }
                    }
                }
                tmpWetatorEngine.executeTests();
            }
            finally {
                tmpWetatorEngine.shutdown();
            }
            int tmpExitCode = 0;
            if (tmpProgressListener.getTestCountError() > 0L || tmpProgressListener.getTestCountFailure() > 0L) {
                tmpExitCode = 1;
            }
            System.exit(tmpExitCode);
        }
        catch (Throwable e) {
            System.out.println("Wetator execution failed: " + e.getMessage());
            LOG.fatal("Wetator execution failed:", e);
            System.exit(1);
        }
    }

    private Wetator() {
    }
}

