/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class KeySequence {
    private final List<Key> keys = new ArrayList<Key>();

    public static KeySequence parse(String aKeySequenceString) {
        KeySequence tmpSequence = new KeySequence();
        if (aKeySequenceString == null) {
            return tmpSequence;
        }
        for (int i = 0; i < aKeySequenceString.length(); ++i) {
            char tmpChar = aKeySequenceString.charAt(i);
            if (tmpChar == '\\') {
                if (++i == aKeySequenceString.length()) {
                    throw new IllegalArgumentException("Invalid escape at pos " + --i + ".");
                }
                tmpSequence.type(aKeySequenceString.charAt(i));
                continue;
            }
            if (tmpChar == '[') {
                int tmpEndPos = aKeySequenceString.indexOf(93, i);
                if (tmpEndPos == -1) {
                    throw new IllegalArgumentException("Invalid special key definition; closing ']' missing.");
                }
                String tmpKeyName = aKeySequenceString.substring(i + 1, tmpEndPos);
                if (!"ENTER".equals(tmpKeyName)) {
                    throw new IllegalArgumentException("Unsupported key '" + tmpKeyName + "'.");
                }
                tmpSequence.pressKey(Key.KEY_RETURN);
                i = tmpEndPos;
                continue;
            }
            tmpSequence.type(tmpChar);
        }
        return tmpSequence;
    }

    public void type(char aChar) {
        this.keys.add(new Key(aChar));
    }

    public void pressKey(Key aKey) {
        this.keys.add(aKey);
    }

    public List<Key> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public String toString() {
        return this.keys.stream().map(k -> String.valueOf(k.getChar())).collect(Collectors.joining());
    }

    public static final class Key {
        public static final Key KEY_RETURN = new Key();
        private char character;

        private Key() {
        }

        Key(char aChar) {
            this.character = aChar;
        }

        public char getChar() {
            return this.character;
        }
    }
}

