/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.html.HtmlElement;
import org.wetator.backend.ControlFeature;
import org.wetator.backend.control.IClickable;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.IDeselectable;
import org.wetator.backend.control.IDisableable;
import org.wetator.backend.control.IFocusable;
import org.wetator.backend.control.ISelectable;
import org.wetator.backend.control.ISettable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;

public class HtmlUnitControlRepository {
    private final Map<String, Class<HtmlUnitBaseControl<?>>> forElementMap = new HashMap();
    private final Map<String, Map<String, Class<HtmlUnitBaseControl<?>>>> forElementAndAttributeMap = new HashMap();
    private final Map<ControlFeature, List<Class<? extends AbstractHtmlUnitControlIdentifier>>> identifiers = new HashMap<ControlFeature, List<Class<? extends AbstractHtmlUnitControlIdentifier>>>();

    public HtmlUnitControlRepository() {
        for (ControlFeature tmpAction : ControlFeature.values()) {
            this.identifiers.put(tmpAction, new LinkedList());
        }
    }

    public void addAll(List<Class<? extends IControl>> aControlClassList) {
        if (aControlClassList != null) {
            for (Class<? extends IControl> tmpControlClass : aControlClassList) {
                this.add(tmpControlClass);
            }
        }
    }

    public void add(Class<? extends IControl> aControlClass) {
        if (aControlClass == null) {
            return;
        }
        if (HtmlUnitBaseControl.class.isAssignableFrom(aControlClass)) {
            HtmlUnitBaseControl.IdentifiedBy tmpIdentifiers;
            HtmlUnitBaseControl.ForHtmlElement tmpForHtmlElement = aControlClass.getAnnotation(HtmlUnitBaseControl.ForHtmlElement.class);
            if (tmpForHtmlElement != null) {
                Class<? extends HtmlElement> tmpHtmlElementClass = tmpForHtmlElement.value();
                String tmpAttributeName = tmpForHtmlElement.attributeName();
                String[] tmpAttributeValues = tmpForHtmlElement.attributeValues();
                if (StringUtils.isEmpty(tmpAttributeName) || tmpAttributeValues == null || tmpAttributeValues.length == 0) {
                    this.forElementMap.put(tmpHtmlElementClass.getName(), aControlClass);
                } else {
                    Map tmpAttributeMap = this.forElementAndAttributeMap.computeIfAbsent(tmpHtmlElementClass.getName(), k -> new HashMap());
                    for (String tmpValue : tmpAttributeValues) {
                        tmpAttributeMap.put(tmpAttributeName + "||" + tmpValue, aControlClass);
                    }
                }
            }
            if ((tmpIdentifiers = aControlClass.getAnnotation(HtmlUnitBaseControl.IdentifiedBy.class)) != null) {
                List<Class<? extends AbstractHtmlUnitControlIdentifier>> tmpIdentifierClasses = Arrays.asList(tmpIdentifiers.value());
                if (IClickable.class.isAssignableFrom(aControlClass)) {
                    this.identifiers.get((Object)ControlFeature.CLICK).addAll(tmpIdentifierClasses);
                    this.identifiers.get((Object)ControlFeature.CLICK_DOUBLE).addAll(tmpIdentifierClasses);
                    this.identifiers.get((Object)ControlFeature.CLICK_RIGHT).addAll(tmpIdentifierClasses);
                }
                if (ISettable.class.isAssignableFrom(aControlClass)) {
                    this.identifiers.get((Object)ControlFeature.SET).addAll(tmpIdentifierClasses);
                }
                if (ISelectable.class.isAssignableFrom(aControlClass)) {
                    this.identifiers.get((Object)ControlFeature.SELECT).addAll(tmpIdentifierClasses);
                }
                if (IDeselectable.class.isAssignableFrom(aControlClass)) {
                    this.identifiers.get((Object)ControlFeature.DESELECT).addAll(tmpIdentifierClasses);
                }
                if (IDisableable.class.isAssignableFrom(aControlClass)) {
                    this.identifiers.get((Object)ControlFeature.DISABLE).addAll(tmpIdentifierClasses);
                }
                if (IFocusable.class.isAssignableFrom(aControlClass)) {
                    this.identifiers.get((Object)ControlFeature.FOCUS).addAll(tmpIdentifierClasses);
                }
            }
        }
    }

    public Class<? extends HtmlUnitBaseControl<?>> getForHtmlElement(HtmlElement anHtmlElement) {
        if (anHtmlElement == null) {
            return null;
        }
        Map<String, Class<HtmlUnitBaseControl<?>>> tmpAttributeMap = this.forElementAndAttributeMap.get(anHtmlElement.getClass().getName());
        if (tmpAttributeMap != null) {
            for (Map.Entry<String, Class<HtmlUnitBaseControl<?>>> tmpEntry : tmpAttributeMap.entrySet()) {
                String[] tmpParts = tmpEntry.getKey().split("\\|\\|");
                if (!tmpParts[1].equals(anHtmlElement.getAttribute(tmpParts[0]))) continue;
                return tmpEntry.getValue();
            }
        }
        return this.forElementMap.get(anHtmlElement.getClass().getName());
    }

    public List<Class<? extends AbstractHtmlUnitControlIdentifier>> getIdentifiers(ControlFeature aFeature) {
        return this.identifiers.get((Object)aFeature);
    }
}

