/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.htmlunit.html.HtmlPage;
import org.wetator.backend.ControlFeature;
import org.wetator.backend.IControlFinder;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.HtmlUnitControlRepository;
import org.wetator.backend.htmlunit.MouseAction;
import org.wetator.backend.htmlunit.finder.AbstractHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.finder.IdentifierBasedHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.finder.MouseActionListeningHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.finder.SettableHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;

public class HtmlUnitFinderDelegator
implements IControlFinder {
    protected HtmlPageIndex htmlPageIndex;
    private static ThreadPoolExecutor threadPool;
    private final Map<ControlFeature, AbstractHtmlUnitControlsFinder> finders = new HashMap<ControlFeature, AbstractHtmlUnitControlsFinder>();

    private static synchronized ThreadPoolExecutor getThreadPool() {
        if (threadPool == null) {
            ThreadPoolExecutor tmpThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            tmpThreadPool.setThreadFactory(new ThreadNamingFactory(tmpThreadPool.getThreadFactory()));
            tmpThreadPool.prestartAllCoreThreads();
            threadPool = tmpThreadPool;
        }
        return threadPool;
    }

    public static synchronized void shutdownThreadPool() throws InterruptedException {
        if (threadPool != null) {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.SECONDS);
            threadPool = null;
        }
    }

    public HtmlUnitFinderDelegator(HtmlPage anHtmlPage) {
        this(anHtmlPage, null);
    }

    public HtmlUnitFinderDelegator(HtmlPage anHtmlPage, HtmlUnitControlRepository aControlRepository) {
        if (null == anHtmlPage) {
            throw new IllegalArgumentException("HtmlPage can't be null");
        }
        this.htmlPageIndex = new HtmlPageIndex(anHtmlPage);
        ThreadPoolExecutor tmpThreadPool = HtmlUnitFinderDelegator.getThreadPool();
        this.finders.put(ControlFeature.CLICK, new MouseActionListeningHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool, MouseAction.CLICK, aControlRepository));
        this.finders.put(ControlFeature.CLICK_DOUBLE, new MouseActionListeningHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool, MouseAction.CLICK_DOUBLE, aControlRepository));
        this.finders.put(ControlFeature.CLICK_RIGHT, new MouseActionListeningHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool, MouseAction.CLICK_RIGHT, aControlRepository));
        this.finders.put(ControlFeature.MOUSE_OVER, new MouseActionListeningHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool, MouseAction.MOUSE_OVER, aControlRepository));
        this.finders.put(ControlFeature.SET, new SettableHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool));
        this.finders.put(ControlFeature.SELECT, new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool));
        this.finders.put(ControlFeature.DESELECT, new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool));
        this.finders.put(ControlFeature.DISABLE, new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool));
        this.finders.put(ControlFeature.FOCUS, new IdentifierBasedHtmlUnitControlsFinder(this.htmlPageIndex, tmpThreadPool));
        if (aControlRepository != null) {
            this.finders.entrySet().stream().filter(e -> e.getValue() instanceof IdentifierBasedHtmlUnitControlsFinder).forEach(e -> ((IdentifierBasedHtmlUnitControlsFinder)e.getValue()).addIdentifiers(aControlRepository.getIdentifiers((ControlFeature)((Object)((Object)e.getKey())))));
        }
    }

    @Override
    public WeightedControlList findControls(ControlFeature aFeature, WPath aWPath) {
        return this.finders.get((Object)aFeature).find(aWPath);
    }

    private static final class ThreadNamingFactory
    implements ThreadFactory {
        private static int id = 1;
        private final ThreadFactory baseFactory;

        private ThreadNamingFactory(ThreadFactory aBaseFactory) {
            this.baseFactory = aBaseFactory;
        }

        @Override
        public Thread newThread(Runnable aRunnable) {
            Thread tmpThread = this.baseFactory.newThread(aRunnable);
            tmpThread.setName("Wetator FinderThread " + id++);
            return tmpThread;
        }
    }
}

