/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.htmlunit.Page;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomComment;
import org.htmlunit.html.DomDocumentType;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNamespaceNode;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlAbbreviated;
import org.htmlunit.html.HtmlAcronym;
import org.htmlunit.html.HtmlArea;
import org.htmlunit.html.HtmlBase;
import org.htmlunit.html.HtmlBig;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlBold;
import org.htmlunit.html.HtmlBreak;
import org.htmlunit.html.HtmlButtonInput;
import org.htmlunit.html.HtmlCanvas;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlCitation;
import org.htmlunit.html.HtmlCode;
import org.htmlunit.html.HtmlDefinition;
import org.htmlunit.html.HtmlDeletedText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlEmbed;
import org.htmlunit.html.HtmlEmphasis;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlFont;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlFrame;
import org.htmlunit.html.HtmlHead;
import org.htmlunit.html.HtmlHeading1;
import org.htmlunit.html.HtmlHeading2;
import org.htmlunit.html.HtmlHeading3;
import org.htmlunit.html.HtmlHeading4;
import org.htmlunit.html.HtmlHeading5;
import org.htmlunit.html.HtmlHeading6;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlHorizontalRule;
import org.htmlunit.html.HtmlHtml;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlInlineQuotation;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlInsertedText;
import org.htmlunit.html.HtmlItalic;
import org.htmlunit.html.HtmlKeyboard;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlMeta;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlParagraph;
import org.htmlunit.html.HtmlParameter;
import org.htmlunit.html.HtmlPasswordInput;
import org.htmlunit.html.HtmlPreformattedText;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlSample;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.html.HtmlSmall;
import org.htmlunit.html.HtmlStrong;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlSubscript;
import org.htmlunit.html.HtmlSuperscript;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableDataCell;
import org.htmlunit.html.HtmlTableHeader;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.HtmlTeletype;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.HtmlTextInput;
import org.htmlunit.html.HtmlTitle;
import org.htmlunit.html.HtmlUnknownElement;
import org.htmlunit.html.HtmlVariable;
import org.htmlunit.javascript.host.html.HTMLCanvasElement;
import org.htmlunit.svg.SvgCircle;
import org.htmlunit.svg.SvgEllipse;
import org.htmlunit.svg.SvgLine;
import org.htmlunit.svg.SvgPath;
import org.htmlunit.svg.SvgPolygon;
import org.htmlunit.svg.SvgPolyline;
import org.htmlunit.svg.SvgRect;
import org.wetator.backend.htmlunit.ResponseStore;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.util.Output;
import org.wetator.util.XMLUtil;

public final class XHtmlOutputter {
    private static final Logger LOG = LogManager.getLogger(XHtmlOutputter.class);
    public static final String JQUERY = "jquery-1.12.4.min.js";
    public static final String JQUERY_COLOR = "jquery.color-3.0.0.min.js";
    private static final Set<String> EMPTY_TAGS;
    private static final Set<String> SINGLE_LINE_TAGS;
    private static final Set<String> IGNORED_ATTRIBUTES;
    private static final Map<Class<? extends Object>, String> TAG_NAMES;
    private HtmlPage htmlPage;
    private ResponseStore responseStore;
    private Output output;
    private XMLUtil xmlUtil;

    public XHtmlOutputter(HtmlPage anHtmlPage, ResponseStore aResponseStore) {
        this.htmlPage = anHtmlPage;
        this.responseStore = aResponseStore;
    }

    public void writeTo(File aFile) throws IOException {
        FileWriterWithEncoding tmpFileWriter = ((FileWriterWithEncoding.Builder)((FileWriterWithEncoding.Builder)FileWriterWithEncoding.builder().setFile(aFile)).setCharset(this.htmlPage.getCharset())).setCharsetEncoder(null).setAppend(false).get();
        this.writeTo(tmpFileWriter);
    }

    public void writeTo(Writer aWriter) throws IOException {
        try {
            this.xmlUtil = new XMLUtil();
            this.output = new Output(aWriter, "  ");
            this.output.println("<?xml version=\"1.0\" encoding=\"" + this.htmlPage.getCharset().name() + "\"?>");
            this.output.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            this.writeSubNodes(this.htmlPage, new Context());
        }
        finally {
            this.output.close();
        }
    }

    private void writeSubNodes(DomNode aDomNode, Context aContext) throws IOException {
        for (DomNode tmpChild = aDomNode.getFirstChild(); null != tmpChild; tmpChild = tmpChild.getNextSibling()) {
            if (tmpChild instanceof DomDocumentType || tmpChild instanceof HtmlScript || tmpChild instanceof DomComment || tmpChild instanceof HtmlBase) continue;
            if (tmpChild instanceof HtmlCanvas) {
                this.writeCanvasImage((HtmlCanvas)tmpChild, aContext);
                continue;
            }
            this.writeStartTag(tmpChild, aContext);
            this.output.indent();
            this.writeSubNodes(tmpChild, aContext);
            this.output.unindent();
            this.writeEndTag(tmpChild, aContext);
        }
    }

    private void writeStartTag(DomNode aDomNode, Context aContext) throws IOException {
        if (aDomNode instanceof HtmlHtml) {
            this.output.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
            this.output.print("<!-- Browser URL: ").print(this.htmlPage.getUrl().toExternalForm()).println(" -->");
        } else if (aDomNode instanceof HtmlUnknownElement) {
            this.output.print('<');
            this.output.print(((HtmlUnknownElement)aDomNode).getQualifiedName());
            this.writeAttributes(aDomNode);
            this.output.println(">");
        } else if (aDomNode instanceof DomElement) {
            if (aDomNode instanceof HtmlPreformattedText) {
                aContext.insidePre++;
            }
            this.output.print('<');
            this.output.print(this.determineTag(aDomNode));
            this.writeAttributes(aDomNode);
            if (aDomNode instanceof HtmlForm) {
                this.output.print(" onsubmit=\"return false;\"");
            }
            if (EMPTY_TAGS.contains(aDomNode.getClass().getName())) {
                this.output.print('/');
                if (HtmlElementUtil.isBlock(aDomNode) && aContext.insidePre == 0) {
                    this.output.println(">");
                } else {
                    this.output.print(">");
                }
            } else if (SINGLE_LINE_TAGS.contains(aDomNode.getClass().getName()) || aContext.insidePre > 0) {
                this.output.print(">");
            } else {
                this.output.println(">");
            }
            if (aDomNode instanceof HtmlHead) {
                this.output.indent();
                this.output.println("<script src='../../resources/jquery-1.12.4.min.js'></script>");
                this.output.println("<script src='../../resources/jquery.color-3.0.0.min.js'></script>");
                this.output.println("<script src='../../resources/wetator_report.js'></script>");
                this.output.unindent();
            }
        } else if (aDomNode instanceof DomText) {
            String tmpText = ((DomText)aDomNode).getData();
            if (StringUtils.isEmpty(tmpText)) {
                this.output.print(tmpText);
            } else {
                DomNode tmpParentNode = aDomNode.getParentNode();
                if (tmpParentNode instanceof HtmlStyle) {
                    this.output.indent();
                    URL tmpBaseUrl = this.htmlPage.getWebResponse().getWebRequest().getUrl();
                    tmpText = this.responseStore.processCSS(tmpBaseUrl, tmpText, 0);
                    this.output.println(tmpText);
                    this.output.unindent();
                } else if (SINGLE_LINE_TAGS.contains(tmpParentNode.getClass().getName()) || aContext.insidePre > 0) {
                    this.output.print(this.xmlUtil.normalizeBodyValue(tmpText));
                } else {
                    this.output.println(this.xmlUtil.normalizeBodyValue(tmpText));
                }
            }
        } else {
            LOG.warn("Unknown DomNode " + aDomNode);
        }
    }

    private void writeEndTag(DomNode aDomNode, Context aContext) throws IOException {
        if (aDomNode instanceof HtmlHtml) {
            this.output.println("</html>");
        } else if (aDomNode instanceof HtmlUnknownElement) {
            this.output.print("</");
            this.output.print(((DomNamespaceNode)aDomNode).getQualifiedName());
            this.output.println(">");
        } else if (aDomNode instanceof DomElement) {
            if (aDomNode instanceof HtmlBody) {
                this.output.indent();
                this.output.println("<script>");
                this.output.indent();
                this.output.println("highlight();");
                this.output.unindent();
                this.output.println("</script>");
                this.output.unindent();
            }
            if (aDomNode instanceof HtmlPreformattedText) {
                aContext.insidePre--;
            }
            if (!EMPTY_TAGS.contains(aDomNode.getClass().getName())) {
                this.output.print("</");
                this.output.print(this.determineTag(aDomNode));
                if (HtmlElementUtil.isBlock(aDomNode) && aContext.insidePre == 0) {
                    this.output.println(">");
                } else {
                    this.output.print(">");
                }
            }
        }
    }

    private void writeAttributes(DomNode aDomNode) throws IOException {
        if (aDomNode instanceof DomElement) {
            HtmlLink tmpHtmlLink;
            DomElement tmpDomElement = (DomElement)aDomNode;
            boolean tmpIsCssLink = false;
            if (tmpDomElement instanceof HtmlLink && "stylesheet".equalsIgnoreCase((tmpHtmlLink = (HtmlLink)tmpDomElement).getRelAttribute())) {
                tmpIsCssLink = true;
            }
            boolean tmpIsHtmlImage = tmpDomElement instanceof HtmlImage;
            boolean tmpIsHtmlImageInput = tmpDomElement instanceof HtmlImageInput;
            boolean tmpIsChecked = tmpDomElement instanceof HtmlCheckBoxInput || tmpDomElement instanceof HtmlRadioButtonInput;
            boolean tmpIsHtmlOption = tmpDomElement instanceof HtmlOption;
            URL tmpBaseUrl = this.htmlPage.getWebResponse().getWebRequest().getUrl();
            HashMap<String, DomAttr> tmpAttributes = new HashMap<String, DomAttr>(tmpDomElement.getAttributesMap());
            if (tmpIsHtmlOption && ((HtmlOption)tmpDomElement).isSelected()) {
                this.output.print(" selected=\"selected\"");
            }
            if (tmpIsChecked && ((HtmlInput)tmpDomElement).isChecked()) {
                this.output.print(" checked=\"checked\"");
            }
            List tmpSortedAttributeNames = tmpAttributes.keySet().stream().map(k -> k.toLowerCase(Locale.ROOT)).sorted().collect(Collectors.toList());
            if (tmpDomElement instanceof HtmlInput) {
                tmpSortedAttributeNames.remove("value");
                tmpSortedAttributeNames.add(0, "value");
                if (tmpSortedAttributeNames.remove("type")) {
                    tmpSortedAttributeNames.add(0, "type");
                }
            }
            if (tmpSortedAttributeNames.remove("name")) {
                tmpSortedAttributeNames.add(0, "name");
            }
            if (tmpSortedAttributeNames.remove("id")) {
                tmpSortedAttributeNames.add(0, "id");
            }
            boolean tmpStyleDefined = false;
            for (String tmpAttributeName : tmpSortedAttributeNames) {
                URL tmpUrl;
                String tmpStoredFileName;
                String tmpAttributeValue;
                DomAttr tmpAttribute = (DomAttr)tmpAttributes.get(tmpAttributeName);
                if (IGNORED_ATTRIBUTES.contains(tmpAttributeName) || tmpIsHtmlOption && "selected".equals(tmpAttributeName) || StringUtils.startsWithIgnoreCase(tmpAttributeValue = tmpDomElement instanceof HtmlInput && "value".equals(tmpAttributeName) ? ((HtmlInput)tmpDomElement).getValue() : tmpAttribute.getNodeValue(), "javascript:")) continue;
                if ("style".equals(tmpAttributeName)) {
                    tmpStyleDefined = true;
                    if (this.responseStore != null) {
                        tmpAttributeValue = this.responseStore.processCSS(tmpBaseUrl, tmpAttributeValue, 0);
                    }
                    if (aDomNode instanceof HtmlElement && !(aDomNode instanceof HtmlOption)) {
                        HtmlElement tmpElement = (HtmlElement)aDomNode;
                        if (!HtmlElement.DisplayStyle.NONE.value().equals(tmpElement.getDefaultStyleDisplay().value())) {
                            ComputedCssStyleDeclaration tmpStyle = tmpElement.getPage().getEnclosingWindow().getComputedStyle(tmpElement, null);
                            tmpAttributeValue = "display: " + tmpStyle.getDisplay() + "; " + tmpAttributeValue;
                        }
                    }
                }
                if (tmpIsCssLink && "href".equals(tmpAttributeName) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), (HtmlLink)tmpDomElement, null, 0, ".css"))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if (tmpIsHtmlImage && "src".equals(tmpAttributeName) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), null, (HtmlImage)tmpDomElement, 0, null))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if ((tmpIsHtmlImageInput || tmpDomElement instanceof HtmlEmbed) && "src".equals(tmpAttributeName) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), null, null, 0, null))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if (tmpDomElement instanceof BaseFrameElement && "src".equals(tmpAttributeName)) {
                    BaseFrameElement tmpFrame = (BaseFrameElement)aDomNode;
                    FrameWindow tmpWebWindow = tmpFrame.getEnclosedWindow();
                    if (null == tmpWebWindow) {
                        LOG.warn("Frame with enclosed EnclosedWindow == null (" + tmpFrame.toString() + ").");
                    } else {
                        Page tmpPage = tmpWebWindow.getEnclosedPage();
                        if (null == tmpPage) {
                            LOG.warn("Frame with enclosed EnclosedPage == null (" + tmpFrame.toString() + ").");
                        } else {
                            String tmpStoredFileName2 = this.responseStore.storePage(tmpPage);
                            if (null != tmpStoredFileName2) {
                                tmpAttributeValue = "../../" + tmpStoredFileName2;
                            }
                        }
                    }
                }
                if ("background".equals(tmpAttributeName) && (tmpDomElement instanceof HtmlTable || tmpDomElement instanceof HtmlTableHeader || tmpDomElement instanceof HtmlTableRow || tmpDomElement instanceof HtmlTableDataCell) && null != (tmpStoredFileName = this.responseStore.storeContentFromUrl(tmpBaseUrl, tmpUrl = tmpDomElement.getHtmlPageOrNull().getFullyQualifiedUrl(tmpAttributeValue), null, null, 0, null))) {
                    tmpAttributeValue = tmpStoredFileName;
                }
                if (tmpDomElement instanceof HtmlPasswordInput && "value".equals(tmpAttributeName) && StringUtils.isNotEmpty(tmpAttributeValue)) {
                    tmpAttributeValue = StringUtils.repeat("*", tmpAttributeValue.length());
                }
                if (tmpDomElement instanceof HtmlSubmitInput && "value".equals(tmpAttributeName) && "Submit Query".equals(tmpAttributeValue)) continue;
                if ("checked".equals(tmpAttributeName)) {
                    if (tmpIsChecked) continue;
                    if (StringUtils.isEmpty(tmpAttributeValue)) {
                        tmpAttributeValue = "checked";
                    }
                }
                if ("multiple".equals(tmpAttributeName) && StringUtils.isEmpty(tmpAttributeValue)) {
                    tmpAttributeValue = "multiple";
                }
                this.output.print(' ');
                this.output.print(tmpAttributeName);
                this.output.print("=\"");
                this.output.print(this.xmlUtil.normalizeAttributeValue(tmpAttributeValue));
                this.output.print('\"');
            }
            if (!tmpStyleDefined && aDomNode instanceof HtmlElement && !(aDomNode instanceof HtmlOption)) {
                HtmlElement tmpElem = (HtmlElement)aDomNode;
                if (!HtmlElement.DisplayStyle.NONE.value().equals(tmpElem.getDefaultStyleDisplay().value())) {
                    ComputedCssStyleDeclaration tmpStyle = tmpElem.getPage().getEnclosingWindow().getComputedStyle(tmpElem, null);
                    this.output.print(" style=\"display: ");
                    this.output.print(tmpStyle.getDisplay());
                    this.output.print('\"');
                }
            }
        }
    }

    private String determineTag(DomNode aDomNode) {
        Class<?> tmpNodeClass = aDomNode.getClass();
        String tmpTag = TAG_NAMES.get(tmpNodeClass);
        if (null != tmpTag) {
            return tmpTag;
        }
        while (tmpNodeClass != HtmlElement.class) {
            try {
                Field tmpField = tmpNodeClass.getDeclaredField("TAG_NAME");
                tmpTag = (String)tmpField.get(null);
                TAG_NAMES.put(tmpNodeClass, tmpTag);
                return tmpTag;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                tmpNodeClass = tmpNodeClass.getSuperclass();
            }
        }
        LOG.warn("Unsupported element " + aDomNode);
        return aDomNode.getClass().getName();
    }

    private void writeCanvasImage(HtmlCanvas aCanvas, Context aContext) throws IOException {
        this.output.print("<!-- ");
        this.writeStartTag(aCanvas, aContext);
        this.output.indent();
        this.writeSubNodes(aCanvas, aContext);
        this.output.unindent();
        this.writeEndTag(aCanvas, aContext);
        this.output.println("-->");
        HTMLCanvasElement tmpCanvas = (HTMLCanvasElement)aCanvas.getScriptableObject();
        this.output.print("<img src='");
        this.output.print(tmpCanvas.toDataURL("png"));
        this.output.print("' height='" + tmpCanvas.getHeight());
        this.output.print("' width='" + tmpCanvas.getWidth());
        String tmpAttrib = aCanvas.getAttribute("style");
        if (DomElement.ATTRIBUTE_NOT_DEFINED != tmpAttrib) {
            this.output.print("' style='" + aCanvas.getAttribute("style"));
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != (tmpAttrib = aCanvas.getAttribute("class"))) {
            this.output.print("' class='" + aCanvas.getAttribute("class"));
        }
        this.output.print("'>");
    }

    static {
        TAG_NAMES = new HashMap<Class<? extends Object>, String>(100);
        EMPTY_TAGS = new HashSet<String>();
        EMPTY_TAGS.add(HtmlMeta.class.getName());
        EMPTY_TAGS.add(HtmlLink.class.getName());
        EMPTY_TAGS.add(HtmlFrame.class.getName());
        EMPTY_TAGS.add(HtmlImage.class.getName());
        EMPTY_TAGS.add(HtmlHiddenInput.class.getName());
        EMPTY_TAGS.add(HtmlTextInput.class.getName());
        EMPTY_TAGS.add(HtmlPasswordInput.class.getName());
        EMPTY_TAGS.add(HtmlSubmitInput.class.getName());
        EMPTY_TAGS.add(HtmlButtonInput.class.getName());
        EMPTY_TAGS.add(HtmlImageInput.class.getName());
        EMPTY_TAGS.add(HtmlCheckBoxInput.class.getName());
        EMPTY_TAGS.add(HtmlRadioButtonInput.class.getName());
        EMPTY_TAGS.add(HtmlFileInput.class.getName());
        EMPTY_TAGS.add(HtmlBreak.class.getName());
        EMPTY_TAGS.add(HtmlHorizontalRule.class.getName());
        EMPTY_TAGS.add(HtmlArea.class.getName());
        EMPTY_TAGS.add(HtmlBase.class.getName());
        EMPTY_TAGS.add(HtmlParameter.class.getName());
        EMPTY_TAGS.add(SvgCircle.class.getName());
        EMPTY_TAGS.add(SvgEllipse.class.getName());
        EMPTY_TAGS.add(SvgLine.class.getName());
        EMPTY_TAGS.add(SvgPath.class.getName());
        EMPTY_TAGS.add(SvgPolygon.class.getName());
        EMPTY_TAGS.add(SvgPolyline.class.getName());
        EMPTY_TAGS.add(SvgRect.class.getName());
        SINGLE_LINE_TAGS = new HashSet<String>();
        SINGLE_LINE_TAGS.add(HtmlTitle.class.getName());
        SINGLE_LINE_TAGS.add(HtmlParagraph.class.getName());
        SINGLE_LINE_TAGS.add(HtmlBreak.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading1.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading2.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading3.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading4.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading5.class.getName());
        SINGLE_LINE_TAGS.add(HtmlHeading6.class.getName());
        SINGLE_LINE_TAGS.add(HtmlOption.class.getName());
        SINGLE_LINE_TAGS.add(HtmlTextArea.class.getName());
        SINGLE_LINE_TAGS.add(HtmlFont.class.getName());
        SINGLE_LINE_TAGS.add(HtmlItalic.class.getName());
        SINGLE_LINE_TAGS.add(HtmlBold.class.getName());
        SINGLE_LINE_TAGS.add(HtmlBig.class.getName());
        SINGLE_LINE_TAGS.add(HtmlCanvas.class.getName());
        SINGLE_LINE_TAGS.add(HtmlEmphasis.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSmall.class.getName());
        SINGLE_LINE_TAGS.add(HtmlStrong.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSubscript.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSuperscript.class.getName());
        SINGLE_LINE_TAGS.add(HtmlInsertedText.class.getName());
        SINGLE_LINE_TAGS.add(HtmlDeletedText.class.getName());
        SINGLE_LINE_TAGS.add(HtmlCode.class.getName());
        SINGLE_LINE_TAGS.add(HtmlKeyboard.class.getName());
        SINGLE_LINE_TAGS.add(HtmlSample.class.getName());
        SINGLE_LINE_TAGS.add(HtmlPreformattedText.class.getName());
        SINGLE_LINE_TAGS.add(HtmlTeletype.class.getName());
        SINGLE_LINE_TAGS.add(HtmlVariable.class.getName());
        SINGLE_LINE_TAGS.add(HtmlAbbreviated.class.getName());
        SINGLE_LINE_TAGS.add(HtmlInlineQuotation.class.getName());
        SINGLE_LINE_TAGS.add(HtmlCitation.class.getName());
        SINGLE_LINE_TAGS.add(HtmlAcronym.class.getName());
        SINGLE_LINE_TAGS.add(HtmlDefinition.class.getName());
        IGNORED_ATTRIBUTES = new HashSet<String>();
        IGNORED_ATTRIBUTES.add("onclick");
        IGNORED_ATTRIBUTES.add("ondblclick");
        IGNORED_ATTRIBUTES.add("onfocus");
        IGNORED_ATTRIBUTES.add("onblur");
        IGNORED_ATTRIBUTES.add("onselect");
        IGNORED_ATTRIBUTES.add("onchange");
        IGNORED_ATTRIBUTES.add("onload");
        IGNORED_ATTRIBUTES.add("onerror");
        IGNORED_ATTRIBUTES.add("onmousemove");
        IGNORED_ATTRIBUTES.add("onmouseover");
        IGNORED_ATTRIBUTES.add("onmouseout");
        IGNORED_ATTRIBUTES.add("onmousedown");
        IGNORED_ATTRIBUTES.add("onmouseup");
        IGNORED_ATTRIBUTES.add("onkeydown");
        IGNORED_ATTRIBUTES.add("onkeyup");
        IGNORED_ATTRIBUTES.add("onkeypress");
    }

    private static final class Context {
        private int insidePre;

        private Context() {
        }
    }
}

