/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.ScriptException;
import org.htmlunit.corejs.javascript.WrappedException;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlPage;
import org.wetator.backend.control.IControl;
import org.wetator.backend.control.ISettable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.IHtmlUnitDisableable;
import org.wetator.backend.htmlunit.control.IHtmlUnitFocusable;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitInputFileIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.AssertionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;
import org.wetator.util.Assert;
import org.wetator.util.SecretString;
import org.wetator.util.StringUtil;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlFileInput.class)
@HtmlUnitBaseControl.IdentifiedBy(value={HtmlUnitInputFileIdentifier.class})
public class HtmlUnitInputFile
extends HtmlUnitBaseControl<HtmlFileInput>
implements ISettable,
IHtmlUnitDisableable<HtmlFileInput>,
IHtmlUnitFocusable<HtmlFileInput> {
    public HtmlUnitInputFile(HtmlFileInput anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        return HtmlElementUtil.getDescribingTextForHtmlFileInput((HtmlFileInput)this.getHtmlElement());
    }

    @Override
    public void setValue(WetatorContext aWetatorContext, SecretString aValue, File aDirectory) throws ActionException {
        String tmpMessage;
        Exception tmpScriptException;
        HtmlFileInput tmpHtmlFileInput = (HtmlFileInput)this.getHtmlElement();
        if (tmpHtmlFileInput.isDisabled()) {
            String tmpMessage2 = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage2);
        }
        if (tmpHtmlFileInput.isReadOnly()) {
            String tmpMessage3 = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage3);
        }
        try {
            HtmlPage tmpHtmlPage = (HtmlPage)tmpHtmlFileInput.getPage();
            DomElement tmpFocusedElement = tmpHtmlPage.getFocusedElement();
            if (tmpFocusedElement == null || tmpHtmlFileInput != tmpFocusedElement) {
                tmpHtmlFileInput.mouseOver();
                tmpHtmlFileInput.mouseMove();
                tmpHtmlFileInput.click();
                tmpFocusedElement = tmpHtmlPage.getFocusedElement();
                if (tmpHtmlFileInput != tmpFocusedElement) {
                    IControl tmpFocusedControl = aWetatorContext.getBrowser().getFocusedControl();
                    if (tmpFocusedControl == null) {
                        aWetatorContext.informListenersInfo("focusRemoved", this.getDescribingText());
                        throw new ActionException("After clicking on the control '" + this.getDescribingText() + "' the focus was removed.");
                    }
                    String tmpDesc = tmpFocusedControl.getDescribingText();
                    aWetatorContext.informListenersInfo("focusChanged", this.getDescribingText(), tmpDesc);
                    if (tmpFocusedControl instanceof ISettable) {
                        ((ISettable)tmpFocusedControl).setValue(aWetatorContext, aValue, aDirectory);
                        return;
                    }
                    throw new ActionException("Focused control '" + tmpDesc + "' is not settable.");
                }
            }
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage4 = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage4, e);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Throwable e) {
            String tmpMessage5 = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage5, e);
        }
        try {
            String tmpValue = aValue.getValue();
            if (StringUtils.isBlank(tmpValue)) {
                tmpHtmlFileInput.setValue("");
            } else {
                List<String> tmpFilenames = StringUtil.extractStrings(tmpValue, ",", 92);
                ArrayList<File> tmpFiles = new ArrayList<File>();
                for (String tmpFilename : tmpFilenames) {
                    File tmpFile = new File(tmpFilename = tmpFilename.trim());
                    if (!tmpFile.isAbsolute() && null != aDirectory) {
                        tmpFile = new File(aDirectory, tmpFilename);
                    }
                    if (!tmpFile.exists()) {
                        String tmpMessage6 = Messages.getMessage("fileNotFound", FilenameUtils.normalize(tmpFile.getAbsolutePath()));
                        throw new ActionException(tmpMessage6);
                    }
                    tmpFiles.add(tmpFile);
                }
                tmpHtmlFileInput.mouseOut();
                tmpFiles.forEach(f -> aWetatorContext.informListenersInfo("setFile", f.getAbsolutePath()));
                tmpHtmlFileInput.setFiles(tmpFiles.toArray(new File[0]));
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (ActionException e) {
            throw e;
        }
        catch (Throwable e) {
            tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public void assertValue(WetatorContext aWetatorContext, SecretString anExpectedValue) throws AssertionException {
        String tmpValue = "";
        if (((HtmlFileInput)this.getHtmlElement()).getFiles() != null && ((HtmlFileInput)this.getHtmlElement()).getFiles().length > 0) {
            tmpValue = Arrays.stream(((HtmlFileInput)this.getHtmlElement()).getFiles()).map(File::getName).collect(Collectors.joining(", "));
        }
        Assert.assertEquals(anExpectedValue, tmpValue, "expectedValueNotFound", new Object[0]);
    }
}

