/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.htmlunit.ScriptException;
import org.htmlunit.corejs.javascript.WrappedException;
import org.htmlunit.html.HtmlLabel;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.wetator.backend.control.ISelectable;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.IHtmlUnitDisableable;
import org.wetator.backend.htmlunit.control.IHtmlUnitFocusable;
import org.wetator.backend.htmlunit.control.identifier.HtmlUnitInputRadioButtonIdentifier;
import org.wetator.backend.htmlunit.util.ExceptionUtil;
import org.wetator.backend.htmlunit.util.HtmlElementUtil;
import org.wetator.core.WetatorContext;
import org.wetator.exception.ActionException;
import org.wetator.exception.BackendException;
import org.wetator.i18n.Messages;

@HtmlUnitBaseControl.ForHtmlElement(value=HtmlRadioButtonInput.class)
@HtmlUnitBaseControl.IdentifiedBy(value={HtmlUnitInputRadioButtonIdentifier.class})
public class HtmlUnitInputRadioButton
extends HtmlUnitBaseControl<HtmlRadioButtonInput>
implements ISelectable,
IHtmlUnitDisableable<HtmlRadioButtonInput>,
IHtmlUnitFocusable<HtmlRadioButtonInput> {
    private static final Logger LOG = LogManager.getLogger(HtmlUnitInputRadioButton.class);
    private HtmlLabel htmlLabel;

    public HtmlUnitInputRadioButton(HtmlRadioButtonInput anHtmlElement) {
        super(anHtmlElement);
    }

    @Override
    public String getDescribingText() {
        HtmlRadioButtonInput tmpHtmlRadioButtonInput = (HtmlRadioButtonInput)this.getHtmlElement();
        StringBuilder tmpText = new StringBuilder(HtmlElementUtil.getDescribingTextForHtmlRadioButtonInput(tmpHtmlRadioButtonInput));
        if (this.htmlLabel != null) {
            tmpText.append(" by ").append(HtmlElementUtil.getDescribingTextForHtmlLabel(this.htmlLabel));
        }
        return tmpText.toString();
    }

    @Override
    public void select(WetatorContext aWetatorContext) throws ActionException {
        HtmlRadioButtonInput tmpHtmlRadioButtonInput = (HtmlRadioButtonInput)this.getHtmlElement();
        if (tmpHtmlRadioButtonInput.isDisabled()) {
            String tmpMessage = Messages.getMessage("elementDisabled", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        if (tmpHtmlRadioButtonInput.isReadOnly()) {
            String tmpMessage = Messages.getMessage("elementReadOnly", this.getDescribingText());
            throw new ActionException(tmpMessage);
        }
        try {
            if (tmpHtmlRadioButtonInput.isChecked()) {
                aWetatorContext.informListenersWarn("elementAlreadySelected", this.getDescribingText());
            } else if (this.htmlLabel == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Select - HtmlUnitInputRadioButton.click() '" + tmpHtmlRadioButtonInput + "'");
                }
                tmpHtmlRadioButtonInput.click();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Select - HtmlUnitInputRadioButton.click() '" + this.htmlLabel + "'");
                }
                this.htmlLabel.click();
            }
            this.waitForImmediateJobs(aWetatorContext);
        }
        catch (ScriptException e) {
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{e.getMessage()}, e);
        }
        catch (WrappedException e) {
            Exception tmpScriptException = ExceptionUtil.getScriptExceptionCauseIfPossible(e);
            aWetatorContext.getBrowser().addFailure("javascriptError", new String[]{tmpScriptException.getMessage()}, tmpScriptException);
        }
        catch (BackendException e) {
            String tmpMessage = Messages.getMessage("backendError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
        catch (Throwable e) {
            String tmpMessage = Messages.getMessage("serverError", e.getMessage(), this.getDescribingText());
            throw new ActionException(tmpMessage, e);
        }
    }

    @Override
    public boolean isSelected(WetatorContext aWetatorContext) {
        return ((HtmlRadioButtonInput)this.getHtmlElement()).isChecked();
    }

    public void setHtmlLabel(HtmlLabel aHtmlLabel) {
        this.htmlLabel = aHtmlLabel;
    }
}

