/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import org.htmlunit.html.HtmlElement;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.exception.ImplementationException;

public abstract class AbstractHtmlUnitControlIdentifier
implements Runnable {
    protected HtmlPageIndex htmlPageIndex;
    private WeightedControlList foundControls;
    private boolean initializedForAsynch;
    private WPath wPath;
    private HtmlElement htmlElement;

    public void initialize(HtmlPageIndex aHtmlPageIndex) {
        this.htmlPageIndex = aHtmlPageIndex;
    }

    public void initializeForAsynch(HtmlPageIndex aHtmlPageIndex, HtmlElement aHtmlElement, WPath aWPath, WeightedControlList aFoundControls) {
        this.initialize(aHtmlPageIndex);
        this.htmlElement = aHtmlElement;
        this.wPath = aWPath;
        this.foundControls = aFoundControls;
        this.initializedForAsynch = true;
    }

    public abstract boolean isHtmlElementSupported(HtmlElement var1);

    @Override
    public void run() {
        if (!this.initializedForAsynch) {
            throw new ImplementationException(this.getClass().getName() + " is not initialized to work asynchronously. Use initializeForAsynch().");
        }
        WeightedControlList tmpResult = this.identify(this.wPath, this.htmlElement);
        if (tmpResult != null) {
            this.foundControls.addAll(tmpResult);
        }
    }

    public abstract WeightedControlList identify(WPath var1, HtmlElement var2);
}

