/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import java.util.List;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlImage;
import org.wetator.backend.WPath;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.control.HtmlUnitImage;
import org.wetator.backend.htmlunit.control.identifier.AbstractMatcherBasedIdentifier;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByAriaLabelAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByDataTestidMatcher;
import org.wetator.backend.htmlunit.matcher.ByIdMatcher;
import org.wetator.backend.htmlunit.matcher.ByImageAltAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByImageSrcAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByLabelingTextBeforeAsTextMatcher;
import org.wetator.backend.htmlunit.matcher.ByNameAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.backend.htmlunit.matcher.ByTitleAttributeMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class HtmlUnitImageIdentifier
extends AbstractMatcherBasedIdentifier {
    @Override
    public boolean isHtmlElementSupported(HtmlElement aHtmlElement) {
        return aHtmlElement instanceof HtmlImage;
    }

    @Override
    protected void addMatchers(WPath aWPath, HtmlElement aHtmlElement, List<AbstractHtmlUnitElementMatcher> aMatchers) {
        SearchPattern tmpPathSearchPattern = null;
        FindSpot tmpPathSpot = null;
        if (!aWPath.getPathNodes().isEmpty()) {
            tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
            tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
        }
        if (tmpPathSpot == FindSpot.NOT_FOUND) {
            return;
        }
        if (aWPath.getLastNode() != null) {
            SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
            aMatchers.add(new ByLabelingTextBeforeAsTextMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern, aWPath));
            aMatchers.add(new ByImageAltAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByImageSrcAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByTitleAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByAriaLabelAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByNameAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByDataTestidMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            aMatchers.add(new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
        } else if (!aWPath.getTableCoordinates().isEmpty()) {
            aMatchers.add(new ByTableCoordinatesMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, aWPath.getTableCoordinatesReversed(), HtmlImage.class));
        }
    }

    @Override
    protected IControl createControl(AbstractHtmlUnitElementMatcher.MatchResult aMatch) {
        return new HtmlUnitImage((HtmlImage)aMatch.getHtmlElement());
    }
}

