/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.control.identifier;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlLabel;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlSelect;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.control.HtmlUnitOption;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class HtmlUnitOptionIdentifier
extends AbstractHtmlUnitControlIdentifier {
    @Override
    public boolean isHtmlElementSupported(HtmlElement aHtmlElement) {
        return aHtmlElement instanceof HtmlOption || aHtmlElement instanceof HtmlLabel && ((HtmlLabel)aHtmlElement).getLabeledElement() instanceof HtmlSelect;
    }

    @Override
    public WeightedControlList identify(WPath aWPath, HtmlElement aHtmlElement) {
        WeightedControlList tmpResult;
        block21: {
            SearchPattern tmpSearchPattern;
            SearchPattern tmpSearchPatternSelect;
            FindSpot tmpPathSpotSelect;
            block20: {
                int tmpDistance;
                int tmpDeviation;
                String tmpId;
                int tmpDeviation2;
                String tmpDataTestid;
                int tmpDeviation3;
                String tmpName;
                int tmpDeviation4;
                String tmpLabelingTextBefore;
                if (aWPath.getLastNode() == null) {
                    return WeightedControlList.EMPTY_LIST;
                }
                tmpPathSpotSelect = null;
                if (aWPath.getPathNodes().isEmpty()) {
                    tmpSearchPatternSelect = SearchPattern.compile("");
                } else {
                    tmpSearchPatternSelect = aWPath.getPathNodes().get(aWPath.getPathNodes().size() - 1).getSearchPattern();
                    if (aWPath.getPathNodes().size() > 1) {
                        SearchPattern tmpPathSearchPatternSelect = SearchPattern.createFromList(aWPath.getPathNodes(), aWPath.getPathNodes().size() - 1);
                        tmpPathSpotSelect = this.htmlPageIndex.firstOccurence(tmpPathSearchPatternSelect);
                    }
                }
                if (tmpPathSpotSelect == FindSpot.NOT_FOUND) {
                    return WeightedControlList.EMPTY_LIST;
                }
                tmpResult = new WeightedControlList();
                tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
                if (!(aHtmlElement instanceof HtmlOption)) break block20;
                HtmlSelect tmpEnclosingSelect = ((HtmlOption)aHtmlElement).getEnclosingSelect();
                FindSpot tmpNodeSpotSelect = this.htmlPageIndex.getPosition(tmpEnclosingSelect);
                if (tmpPathSpotSelect != null && tmpPathSpotSelect.getEndPos() > tmpNodeSpotSelect.getStartPos()) break block21;
                int tmpStartPos = 0;
                if (tmpPathSpotSelect != null) {
                    tmpStartPos = tmpPathSpotSelect.getEndPos();
                }
                if (StringUtils.isNotEmpty(tmpLabelingTextBefore = this.htmlPageIndex.getLabelingTextBefore(tmpEnclosingSelect, tmpStartPos)) && (tmpDeviation4 = tmpSearchPatternSelect.noOfSurroundingCharsIn(tmpLabelingTextBefore)) > -1) {
                    int tmpDistance2;
                    if (aWPath.getPathNodes().isEmpty()) {
                        String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpEnclosingSelect);
                        tmpDistance2 = tmpTextBefore.length();
                    } else {
                        tmpDistance2 = tmpSearchPatternSelect.noOfCharsAfterLastOccurenceIn(tmpLabelingTextBefore);
                    }
                    this.identifyOption(tmpEnclosingSelect, (HtmlOption)aHtmlElement, tmpSearchPattern, aWPath.getTableCoordinatesReversed(), tmpDistance2, tmpResult);
                }
                if (StringUtils.isNotEmpty(tmpName = tmpEnclosingSelect.getAttribute("name")) && tmpSearchPatternSelect.matches(tmpName) && (tmpDeviation3 = tmpSearchPatternSelect.noOfSurroundingCharsIn(tmpName)) > -1) {
                    int tmpDistance3;
                    if (aWPath.getPathNodes().isEmpty()) {
                        String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpEnclosingSelect);
                        tmpDistance3 = tmpTextBefore.length();
                    } else {
                        tmpDistance3 = 0;
                    }
                    this.identifyOption(tmpEnclosingSelect, (HtmlOption)aHtmlElement, tmpSearchPattern, aWPath.getTableCoordinatesReversed(), tmpDistance3, tmpResult);
                }
                if (StringUtils.isNotEmpty(tmpDataTestid = tmpEnclosingSelect.getAttribute("data-testid")) && tmpSearchPatternSelect.matches(tmpDataTestid) && (tmpDeviation2 = tmpSearchPatternSelect.noOfSurroundingCharsIn(tmpDataTestid)) > -1) {
                    int tmpDistance4;
                    if (aWPath.getPathNodes().isEmpty()) {
                        String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpEnclosingSelect);
                        tmpDistance4 = tmpTextBefore.length();
                    } else {
                        tmpDistance4 = 0;
                    }
                    this.identifyOption(tmpEnclosingSelect, (HtmlOption)aHtmlElement, tmpSearchPattern, aWPath.getTableCoordinatesReversed(), tmpDistance4, tmpResult);
                }
                if (!StringUtils.isNotEmpty(tmpId = tmpEnclosingSelect.getId()) || !tmpSearchPatternSelect.matches(tmpId) || (tmpDeviation = tmpSearchPatternSelect.noOfSurroundingCharsIn(tmpId)) <= -1) break block21;
                if (aWPath.getPathNodes().isEmpty()) {
                    String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpEnclosingSelect);
                    tmpDistance = tmpTextBefore.length();
                } else {
                    tmpDistance = 0;
                }
                this.identifyOption(tmpEnclosingSelect, (HtmlOption)aHtmlElement, tmpSearchPattern, aWPath.getTableCoordinatesReversed(), tmpDistance, tmpResult);
                break block21;
            }
            if (aHtmlElement instanceof HtmlLabel) {
                HtmlElement tmpLabeledElement;
                HtmlLabel tmpLabel;
                String tmpText;
                int tmpDeviation;
                FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
                if ((tmpPathSpotSelect == null || tmpPathSpotSelect.getEndPos() <= tmpNodeSpot.getStartPos()) && (tmpDeviation = tmpSearchPatternSelect.noOfCharsAfterLastOccurenceIn(tmpText = this.htmlPageIndex.getAsTextWithoutFormControls(tmpLabel = (HtmlLabel)aHtmlElement))) > -1 && (tmpLabeledElement = tmpLabel.getLabeledElement()) instanceof HtmlSelect && this.htmlPageIndex.isVisible(tmpLabeledElement)) {
                    String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpLabeledElement);
                    int tmpDistance = aWPath.getPathNodes().isEmpty() ? tmpTextBefore.length() : tmpSearchPatternSelect.noOfCharsAfterLastOccurenceIn(tmpTextBefore);
                    HtmlSelect tmpSelect = (HtmlSelect)tmpLabeledElement;
                    for (HtmlOption tmpOption : tmpSelect.getOptions()) {
                        this.identifyOption(tmpSelect, tmpOption, tmpSearchPattern, aWPath.getTableCoordinatesReversed(), tmpDistance, tmpResult);
                    }
                }
            }
        }
        return tmpResult;
    }

    private void identifyOption(HtmlSelect aSelect, HtmlOption anOption, SearchPattern aSearchPattern, List<WPath.TableCoordinate> aTableCoordinates, int aDistance, WeightedControlList aWeightedControlList) {
        int tmpDeviation;
        String tmpLabel;
        int tmpDeviation2;
        String tmpText;
        int tmpDeviation3;
        String tmpId;
        int tmpDeviation4;
        int tmpStart = this.htmlPageIndex.getPosition(anOption).getStartPos();
        String tmpDataTestid = anOption.getAttribute("data-testid");
        if (StringUtils.isNotEmpty(tmpDataTestid) && aSearchPattern.getMinLength() > 0 && aSearchPattern.matches(tmpDataTestid) && (tmpDeviation4 = aSearchPattern.noOfSurroundingCharsIn(tmpDataTestid)) > -1) {
            boolean tmpIsInTable;
            boolean bl = tmpIsInTable = aTableCoordinates.isEmpty() || ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(aSelect, aTableCoordinates, this.htmlPageIndex, null);
            if (tmpIsInTable) {
                aWeightedControlList.add(new HtmlUnitOption(anOption), WeightedControlList.FoundType.BY_DATA_TESTID, tmpDeviation4, aDistance, tmpStart, this.htmlPageIndex.getHierarchy(anOption), this.htmlPageIndex.getIndex(anOption));
            }
        }
        if (StringUtils.isNotEmpty(tmpId = anOption.getId()) && aSearchPattern.getMinLength() > 0 && aSearchPattern.matches(tmpId) && (tmpDeviation3 = aSearchPattern.noOfSurroundingCharsIn(tmpId)) > -1) {
            boolean tmpIsInTable;
            boolean bl = tmpIsInTable = aTableCoordinates.isEmpty() || ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(aSelect, aTableCoordinates, this.htmlPageIndex, null);
            if (tmpIsInTable) {
                aWeightedControlList.add(new HtmlUnitOption(anOption), WeightedControlList.FoundType.BY_ID, tmpDeviation3, aDistance, tmpStart, this.htmlPageIndex.getHierarchy(anOption), this.htmlPageIndex.getIndex(anOption));
            }
        }
        if ((tmpText = this.htmlPageIndex.getAsText(anOption)) != null && (tmpDeviation2 = aSearchPattern.noOfSurroundingCharsIn(tmpText)) > -1) {
            boolean tmpIsInTable;
            if (aSearchPattern.getMinLength() == 0) {
                tmpDeviation2 = tmpText.length();
            }
            boolean bl = tmpIsInTable = aTableCoordinates.isEmpty() || ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(aSelect, aTableCoordinates, this.htmlPageIndex, null);
            if (tmpIsInTable) {
                aWeightedControlList.add(new HtmlUnitOption(anOption), WeightedControlList.FoundType.BY_LABEL, tmpDeviation2, aDistance, tmpStart, this.htmlPageIndex.getHierarchy(anOption), this.htmlPageIndex.getIndex(anOption));
            }
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED != (tmpLabel = anOption.getLabelAttribute()) && (tmpDeviation = aSearchPattern.noOfSurroundingCharsIn(tmpLabel)) > -1) {
            boolean tmpIsInTable;
            if (aSearchPattern.getMinLength() == 0) {
                tmpDeviation = tmpLabel.length();
            }
            boolean bl = tmpIsInTable = aTableCoordinates.isEmpty() || ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(aSelect, aTableCoordinates, this.htmlPageIndex, null);
            if (tmpIsInTable) {
                aWeightedControlList.add(new HtmlUnitOption(anOption), WeightedControlList.FoundType.BY_LABEL, tmpDeviation, aDistance, tmpStart, this.htmlPageIndex.getHierarchy(anOption), this.htmlPageIndex.getIndex(anOption));
            }
        }
    }
}

