/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.finder;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.htmlunit.html.HtmlElement;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;
import org.wetator.backend.htmlunit.finder.AbstractHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.exception.ImplementationException;

public class IdentifierBasedHtmlUnitControlsFinder
extends AbstractHtmlUnitControlsFinder {
    protected ThreadPoolExecutor threadPool;
    protected final List<Class<? extends AbstractHtmlUnitControlIdentifier>> identifiers = new ArrayList<Class<? extends AbstractHtmlUnitControlIdentifier>>();
    private final List<Future<?>> futures = new LinkedList();

    public IdentifierBasedHtmlUnitControlsFinder(HtmlPageIndex aHtmlPageIndex, ThreadPoolExecutor aThreadPool) {
        super(aHtmlPageIndex);
        this.threadPool = aThreadPool;
        if (null == this.threadPool) {
            this.threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            this.threadPool.prestartAllCoreThreads();
        }
    }

    public void addIdentifier(Class<? extends AbstractHtmlUnitControlIdentifier> anIdentifier) {
        this.identifiers.add(anIdentifier);
    }

    public void addIdentifiers(List<Class<? extends AbstractHtmlUnitControlIdentifier>> anIdentifierList) {
        this.identifiers.addAll(anIdentifierList);
    }

    @Override
    public WeightedControlList find(WPath aWPath) {
        WeightedControlList tmpFoundControls = new WeightedControlList();
        for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElements()) {
            this.identify(tmpHtmlElement, aWPath, tmpFoundControls);
        }
        this.waitUntilExecuted();
        return tmpFoundControls;
    }

    protected boolean identify(HtmlElement aHtmlElement, WPath aWPath, WeightedControlList aFoundControls) {
        boolean tmpSupported = false;
        for (Class<? extends AbstractHtmlUnitControlIdentifier> tmpIdentifierClass : this.identifiers) {
            tmpSupported |= this.identify(tmpIdentifierClass, aHtmlElement, aWPath, aFoundControls);
        }
        return tmpSupported;
    }

    protected boolean identify(Class<? extends AbstractHtmlUnitControlIdentifier> anIdentifierClass, HtmlElement aHtmlElement, WPath aWPath, WeightedControlList aFoundControls) {
        try {
            AbstractHtmlUnitControlIdentifier tmpIdentifier = anIdentifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            tmpIdentifier.initializeForAsynch(this.htmlPageIndex, aHtmlElement, aWPath, aFoundControls);
            if (tmpIdentifier.isHtmlElementSupported(aHtmlElement)) {
                this.execute(tmpIdentifier);
                return true;
            }
        }
        catch (IllegalAccessException e) {
            throw new ImplementationException("Could not access identifier class '" + anIdentifierClass.getName() + "'.", e);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ImplementationException("Could not instantiate identifier for class '" + anIdentifierClass.getName() + "'.", e);
        }
        return false;
    }

    protected void execute(AbstractHtmlUnitControlIdentifier anIdentifier) {
        this.futures.add(this.threadPool.submit(anIdentifier));
    }

    protected void waitUntilExecuted() {
        for (Future<?> tmpFuture : this.futures) {
            try {
                tmpFuture.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Exception waiting for executed threads.", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ImplementationException) {
                    throw (ImplementationException)e.getCause();
                }
                throw new ImplementationException("Exception occured in executed thread.", e.getCause());
            }
        }
    }
}

