/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.finder;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlLabel;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.control.IControl;
import org.wetator.backend.htmlunit.HtmlUnitControlRepository;
import org.wetator.backend.htmlunit.MouseAction;
import org.wetator.backend.htmlunit.control.HtmlUnitBaseControl;
import org.wetator.backend.htmlunit.control.HtmlUnitUnspecificControl;
import org.wetator.backend.htmlunit.control.identifier.AbstractHtmlUnitControlIdentifier;
import org.wetator.backend.htmlunit.control.identifier.AbstractMatcherBasedIdentifier;
import org.wetator.backend.htmlunit.finder.IdentifierBasedHtmlUnitControlsFinder;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.matcher.ByAriaLabelAttributeMatcher;
import org.wetator.backend.htmlunit.matcher.ByDataTestidMatcher;
import org.wetator.backend.htmlunit.matcher.ByIdMatcher;
import org.wetator.backend.htmlunit.matcher.ByTableCoordinatesMatcher;
import org.wetator.backend.htmlunit.matcher.ByTextMatcher;
import org.wetator.backend.htmlunit.matcher.ByTitleAttributeMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class MouseActionListeningHtmlUnitControlsFinder
extends IdentifierBasedHtmlUnitControlsFinder {
    private static final String PAGE_WPATH = "$PAGE";
    private final MouseAction mouseAction;
    private boolean supportUnknownControlsWithoutListener = true;
    private final HtmlUnitControlRepository controlRepository;

    public MouseActionListeningHtmlUnitControlsFinder(HtmlPageIndex aHtmlPageIndex, ThreadPoolExecutor aThreadPool, MouseAction aMouseAction, HtmlUnitControlRepository aControlRepository) {
        super(aHtmlPageIndex, aThreadPool);
        this.mouseAction = aMouseAction;
        this.controlRepository = aControlRepository;
    }

    @Override
    public WeightedControlList find(WPath aWPath) {
        if (aWPath.getPathNodes().isEmpty() && aWPath.getTableCoordinates().isEmpty() && aWPath.getLastNode() != null && PAGE_WPATH.equals(aWPath.getLastNode().getValue())) {
            for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElements()) {
                if (!(tmpHtmlElement instanceof HtmlBody)) continue;
                WeightedControlList tmpFoundControls = new WeightedControlList();
                tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlBody>((HtmlBody)tmpHtmlElement), WeightedControlList.FoundType.BY_ID, 0, 0, this.htmlPageIndex.getPosition(tmpHtmlElement).getStartPos(), this.htmlPageIndex.getHierarchy(tmpHtmlElement), this.htmlPageIndex.getIndex(tmpHtmlElement));
                return tmpFoundControls;
            }
        }
        WeightedControlList tmpFoundControls = super.find(aWPath);
        if (this.supportUnknownControlsWithoutListener) {
            if (aWPath.getLastNode() == null && aWPath.getTableCoordinates().isEmpty()) {
                return tmpFoundControls;
            }
            SearchPattern tmpPathSearchPattern = null;
            FindSpot tmpPathSpot = null;
            if (!aWPath.getPathNodes().isEmpty()) {
                tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
                tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
            }
            if (tmpPathSpot == FindSpot.NOT_FOUND) {
                return tmpFoundControls;
            }
            if (aWPath.getLastNode() == null || aWPath.getLastNode().isEmpty()) {
                int tmpStartPos = 0;
                if (tmpPathSpot != null) {
                    tmpStartPos = Math.max(0, tmpPathSpot.getEndPos());
                }
                for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElementsBottomUp()) {
                    FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(tmpHtmlElement);
                    if (tmpStartPos > tmpNodeSpot.getStartPos() || this.controlRepository != null && this.controlRepository.getForHtmlElement(tmpHtmlElement) != null || !aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpHtmlElement, aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, null)) continue;
                    String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpHtmlElement);
                    int tmpDeviation = this.htmlPageIndex.getAsText(tmpHtmlElement).length();
                    int tmpDistance = tmpPathSearchPattern != null ? tmpPathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
                    tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpHtmlElement), WeightedControlList.FoundType.BY_TEXT, tmpDeviation, tmpDistance, tmpNodeSpot.getStartPos(), this.htmlPageIndex.getHierarchy(tmpHtmlElement), this.htmlPageIndex.getIndex(tmpHtmlElement));
                    break;
                }
                return tmpFoundControls;
            }
            SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
            int tmpStartPos = 0;
            if (tmpPathSpot != null) {
                tmpStartPos = Math.max(0, tmpPathSpot.getEndPos());
            }
            FindSpot tmpHitSpot = this.htmlPageIndex.firstOccurence(tmpSearchPattern, tmpStartPos);
            while (tmpHitSpot != FindSpot.NOT_FOUND && tmpHitSpot.getEndPos() > -1) {
                for (HtmlElement tmpHtmlElement : this.htmlPageIndex.getAllVisibleHtmlElementsBottomUp()) {
                    FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(tmpHtmlElement);
                    if (tmpNodeSpot.getStartPos() > tmpHitSpot.getStartPos() || tmpHitSpot.getEndPos() > tmpNodeSpot.getEndPos()) continue;
                    if (this.controlRepository != null && this.controlRepository.getForHtmlElement(tmpHtmlElement) != null || !aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpHtmlElement, aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, null)) break;
                    String tmpTextBefore = this.htmlPageIndex.getTextBeforeIncludingMyself(tmpHtmlElement);
                    FindSpot tmpLastOccurence = tmpSearchPattern.lastOccurenceIn(tmpTextBefore);
                    int tmpDeviation = tmpTextBefore.length() - tmpLastOccurence.getEndPos();
                    tmpTextBefore = tmpTextBefore.substring(0, tmpLastOccurence.getStartPos());
                    int tmpDistance = tmpPathSearchPattern != null ? tmpPathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
                    tmpFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpHtmlElement), WeightedControlList.FoundType.BY_TEXT, tmpDeviation, tmpDistance, tmpNodeSpot.getStartPos(), this.htmlPageIndex.getHierarchy(tmpHtmlElement), this.htmlPageIndex.getIndex(tmpHtmlElement));
                    break;
                }
                tmpHitSpot = this.htmlPageIndex.firstOccurence(tmpSearchPattern, tmpHitSpot.getStartPos() + 1);
            }
        }
        return tmpFoundControls;
    }

    @Override
    protected boolean identify(HtmlElement aHtmlElement, WPath aWPath, WeightedControlList aFoundControls) {
        boolean tmpSupported = super.identify(aHtmlElement, aWPath, aFoundControls);
        if (!tmpSupported) {
            Class<HtmlUnitBaseControl<?>> tmpControlClass;
            HtmlLabel tmpHtmlLabel;
            HtmlElement tmpLabeledElement;
            if (this.htmlPageIndex.hasMouseActionListener(this.mouseAction, aHtmlElement)) {
                Class<HtmlUnitBaseControl<?>> tmpControlClass2;
                if (this.controlRepository != null && (tmpControlClass2 = this.controlRepository.getForHtmlElement(aHtmlElement)) != null) {
                    HtmlUnitBaseControl.IdentifiedBy tmpIdentifiedBy = tmpControlClass2.getAnnotation(HtmlUnitBaseControl.IdentifiedBy.class);
                    for (Class<? extends AbstractHtmlUnitControlIdentifier> tmpIdentifierClass : tmpIdentifiedBy.value()) {
                        tmpSupported |= this.identify(tmpIdentifierClass, aHtmlElement, aWPath, aFoundControls);
                    }
                }
                if (!tmpSupported) {
                    tmpSupported |= this.identify(HtmlUnitUnspecificControlIdentifier.class, aHtmlElement, aWPath, aFoundControls);
                }
            }
            if (aHtmlElement instanceof HtmlLabel && this.controlRepository != null && this.htmlPageIndex.hasMouseActionListener(this.mouseAction, tmpLabeledElement = (tmpHtmlLabel = (HtmlLabel)aHtmlElement).getLabeledElement()) && (tmpControlClass = this.controlRepository.getForHtmlElement(tmpLabeledElement)) != null) {
                HtmlUnitBaseControl.IdentifiedBy tmpIdentifiedBy = tmpControlClass.getAnnotation(HtmlUnitBaseControl.IdentifiedBy.class);
                for (Class<? extends AbstractHtmlUnitControlIdentifier> tmpIdentifierClass : tmpIdentifiedBy.value()) {
                    tmpSupported |= this.identify(tmpIdentifierClass, aHtmlElement, aWPath, aFoundControls);
                }
            }
        }
        if (!(tmpSupported || !this.supportUnknownControlsWithoutListener || aWPath.getLastNode() == null || aWPath.getLastNode().isEmpty() || this.controlRepository != null && this.controlRepository.getForHtmlElement(aHtmlElement) != null)) {
            SearchPattern tmpPathSearchPattern = null;
            FindSpot tmpPathSpot = null;
            if (!aWPath.getPathNodes().isEmpty()) {
                tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
                tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
            }
            if (tmpPathSpot != FindSpot.NOT_FOUND) {
                SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
                ByIdMatcher tmpIdMatcher = new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern);
                ByTitleAttributeMatcher tmpTitleMatcher = new ByTitleAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern);
                List<AbstractHtmlUnitElementMatcher.MatchResult> tmpMatches = tmpIdMatcher.matches(aHtmlElement);
                for (AbstractHtmlUnitElementMatcher.MatchResult tmpMatch : tmpMatches) {
                    if (!aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpMatch.getHtmlElement(), aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, tmpPathSpot)) continue;
                    aFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpMatch.getHtmlElement()), tmpMatch.getFoundType(), tmpMatch.getDeviation(), tmpMatch.getDistance(), tmpMatch.getStart(), this.htmlPageIndex.getHierarchy(tmpMatch.getHtmlElement()), this.htmlPageIndex.getIndex(tmpMatch.getHtmlElement()));
                }
                tmpMatches = tmpTitleMatcher.matches(aHtmlElement);
                for (AbstractHtmlUnitElementMatcher.MatchResult tmpMatch : tmpMatches) {
                    if (!aWPath.getTableCoordinates().isEmpty() && !ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(tmpMatch.getHtmlElement(), aWPath.getTableCoordinatesReversed(), this.htmlPageIndex, null)) continue;
                    aFoundControls.add(new HtmlUnitUnspecificControl<HtmlElement>(tmpMatch.getHtmlElement()), WeightedControlList.FoundType.BY_TITLE_TEXT, tmpMatch.getDeviation(), tmpMatch.getDistance(), tmpMatch.getStart(), this.htmlPageIndex.getHierarchy(tmpMatch.getHtmlElement()), this.htmlPageIndex.getIndex(tmpMatch.getHtmlElement()));
                }
            }
        }
        return tmpSupported;
    }

    public void setSupportUnknownControlsWithoutListener(boolean aSupportUnknownControlsWithoutListener) {
        this.supportUnknownControlsWithoutListener = aSupportUnknownControlsWithoutListener;
    }

    static class HtmlUnitUnspecificControlIdentifier
    extends AbstractMatcherBasedIdentifier {
        HtmlUnitUnspecificControlIdentifier() {
        }

        @Override
        public boolean isHtmlElementSupported(HtmlElement aHtmlElement) {
            return true;
        }

        @Override
        protected void addMatchers(WPath aWPath, HtmlElement aHtmlElement, List<AbstractHtmlUnitElementMatcher> aMatchers) {
            SearchPattern tmpPathSearchPattern = null;
            FindSpot tmpPathSpot = null;
            if (!aWPath.getPathNodes().isEmpty()) {
                tmpPathSearchPattern = SearchPattern.createFromList(aWPath.getPathNodes());
                tmpPathSpot = this.htmlPageIndex.firstOccurence(tmpPathSearchPattern);
            }
            if (tmpPathSpot == FindSpot.NOT_FOUND) {
                return;
            }
            if (aWPath.getLastNode() != null) {
                SearchPattern tmpSearchPattern = aWPath.getLastNode().getSearchPattern();
                aMatchers.add(new ByTextMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByTitleAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByAriaLabelAttributeMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByDataTestidMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
                aMatchers.add(new ByIdMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, tmpSearchPattern));
            } else if (!aWPath.getTableCoordinates().isEmpty()) {
                aMatchers.add(new ByTableCoordinatesMatcher(this.htmlPageIndex, tmpPathSearchPattern, tmpPathSpot, aWPath.getTableCoordinatesReversed(), HtmlElement.class));
            }
        }

        @Override
        protected IControl createControl(AbstractHtmlUnitElementMatcher.MatchResult aMatch) {
            return new HtmlUnitUnspecificControl<HtmlElement>(aMatch.getHtmlElement());
        }
    }
}

