/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.matcher;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.html.HtmlElement;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public abstract class AbstractByAttributeMatcher
extends AbstractHtmlUnitElementMatcher {
    protected MatchType matchType = MatchType.CONTAINS;
    private final WeightedControlList.FoundType foundType;

    public AbstractByAttributeMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, WeightedControlList.FoundType aFoundType) {
        super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern);
        this.foundType = aFoundType;
    }

    @Override
    public List<AbstractHtmlUnitElementMatcher.MatchResult> matches(HtmlElement aHtmlElement) {
        int tmpDeviation;
        String tmpValue;
        if (FindSpot.NOT_FOUND == this.pathSpot) {
            return Collections.emptyList();
        }
        if (this.searchPattern.getMinLength() == 0) {
            return Collections.emptyList();
        }
        FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
        if ((this.pathSpot == null || this.pathSpot.getEndPos() <= tmpNodeSpot.getStartPos()) && StringUtils.isNotEmpty(tmpValue = this.getAttributeValue(aHtmlElement)) && (MatchType.CONTAINS == this.matchType || MatchType.STARTS_WITH == this.matchType || MatchType.EXACT == this.matchType && this.searchPattern.matches(tmpValue) || MatchType.ENDS_WITH == this.matchType && this.searchPattern.matchesAtEnd(tmpValue)) && (tmpDeviation = MatchType.ENDS_WITH == this.matchType ? this.searchPattern.noOfCharsBeforeLastOccurenceIn(tmpValue) : (MatchType.STARTS_WITH == this.matchType ? this.searchPattern.noOfCharsAfterLastOccurenceIn(tmpValue) : this.searchPattern.noOfSurroundingCharsIn(tmpValue))) > -1) {
            String tmpTextBefore = this.htmlPageIndex.getTextBefore(aHtmlElement);
            tmpTextBefore = this.processTextForDistance(tmpTextBefore);
            int tmpDistance = this.pathSearchPattern != null ? this.pathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
            return Collections.singletonList(new AbstractHtmlUnitElementMatcher.MatchResult(aHtmlElement, this.foundType, tmpDeviation, tmpDistance, tmpNodeSpot.getStartPos()));
        }
        return Collections.emptyList();
    }

    protected abstract String getAttributeValue(HtmlElement var1);

    protected String processTextForDistance(String aText) {
        return aText;
    }

    protected static enum MatchType {
        CONTAINS,
        EXACT,
        STARTS_WITH,
        ENDS_WITH;

    }
}

