/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.matcher;

import java.util.Collections;
import java.util.List;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlLabel;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class ByHtmlLabelMatcher
extends AbstractHtmlUnitElementMatcher {
    private final Class<? extends HtmlElement> clazz;
    private final boolean matchInvisible;

    public ByHtmlLabelMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, Class<? extends HtmlElement> aClass) {
        this(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern, aClass, false);
    }

    public ByHtmlLabelMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, SearchPattern aSearchPattern, Class<? extends HtmlElement> aClass, boolean aMatchInvisible) {
        super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, aSearchPattern);
        this.clazz = aClass;
        this.matchInvisible = aMatchInvisible;
    }

    @Override
    public List<AbstractHtmlUnitElementMatcher.MatchResult> matches(HtmlElement aHtmlElement) {
        HtmlElement tmpLabeledElement;
        HtmlLabel tmpLabel;
        String tmpText;
        int tmpDeviation;
        if (!(aHtmlElement instanceof HtmlLabel)) {
            return Collections.emptyList();
        }
        if (FindSpot.NOT_FOUND == this.pathSpot) {
            return Collections.emptyList();
        }
        if (this.searchPattern.getMinLength() == 0) {
            return Collections.emptyList();
        }
        FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
        if ((this.pathSpot == null || this.pathSpot.getEndPos() <= tmpNodeSpot.getStartPos()) && (tmpDeviation = this.searchPattern.noOfSurroundingCharsIn(tmpText = this.htmlPageIndex.getAsTextWithoutFormControls(tmpLabel = (HtmlLabel)aHtmlElement))) > -1 && (tmpLabeledElement = tmpLabel.getLabeledElement()) != null && this.clazz.isAssignableFrom(tmpLabeledElement.getClass()) && (this.htmlPageIndex.isVisible(tmpLabeledElement) || this.matchInvisible)) {
            tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
            String tmpTextBefore = this.htmlPageIndex.getTextBefore(tmpLabel);
            int tmpDistance = this.pathSearchPattern != null ? this.pathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
            return Collections.singletonList(new ByHtmlLabelMatchResult(tmpLabeledElement, tmpLabel, WeightedControlList.FoundType.BY_LABEL_ELEMENT, tmpDeviation, tmpDistance, tmpNodeSpot.getStartPos()));
        }
        return Collections.emptyList();
    }

    public static class ByHtmlLabelMatchResult
    extends AbstractHtmlUnitElementMatcher.MatchResult {
        private final HtmlLabel label;

        public ByHtmlLabelMatchResult(HtmlElement aHtmlElement, HtmlLabel aLabel, WeightedControlList.FoundType aFoundType, int aDeviation, int aDistance, int aStart) {
            super(aHtmlElement, aFoundType, aDeviation, aDistance, aStart);
            this.label = aLabel;
        }

        public HtmlLabel getLabel() {
            return this.label;
        }
    }
}

