/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableCell;
import org.htmlunit.html.HtmlTableRow;
import org.wetator.backend.WPath;
import org.wetator.backend.WeightedControlList;
import org.wetator.backend.htmlunit.matcher.AbstractHtmlUnitElementMatcher;
import org.wetator.backend.htmlunit.util.HtmlPageIndex;
import org.wetator.core.searchpattern.SearchPattern;
import org.wetator.util.FindSpot;

public class ByTableCoordinatesMatcher
extends AbstractHtmlUnitElementMatcher {
    private final List<WPath.TableCoordinate> tableCoordinates;
    private final Class<? extends HtmlElement> clazz;

    public ByTableCoordinatesMatcher(HtmlPageIndex aHtmlPageIndex, SearchPattern aPathSearchPattern, FindSpot aPathSpot, List<WPath.TableCoordinate> aTableCoordinates, Class<? extends HtmlElement> aClass) {
        super(aHtmlPageIndex, aPathSearchPattern, aPathSpot, null);
        this.tableCoordinates = aTableCoordinates;
        this.clazz = aClass;
    }

    @Override
    public List<AbstractHtmlUnitElementMatcher.MatchResult> matches(HtmlElement aHtmlElement) {
        if (!this.clazz.isAssignableFrom(aHtmlElement.getClass())) {
            return Collections.emptyList();
        }
        if (FindSpot.NOT_FOUND == this.pathSpot) {
            return Collections.emptyList();
        }
        FindSpot tmpNodeSpot = this.htmlPageIndex.getPosition(aHtmlElement);
        if ((this.pathSpot == null || this.pathSpot.getEndPos() <= tmpNodeSpot.getStartPos()) && ByTableCoordinatesMatcher.isHtmlElementInTableCoordinates(aHtmlElement, this.tableCoordinates, this.htmlPageIndex, this.pathSpot)) {
            String tmpTextBefore = this.htmlPageIndex.getTextBefore(aHtmlElement);
            int tmpDistance = this.pathSearchPattern != null ? this.pathSearchPattern.noOfCharsAfterLastShortestOccurenceIn(tmpTextBefore) : tmpTextBefore.length();
            return Collections.singletonList(new AbstractHtmlUnitElementMatcher.MatchResult(aHtmlElement, WeightedControlList.FoundType.BY_TABLE_COORDINATE, 0, tmpDistance, tmpNodeSpot.getStartPos()));
        }
        return Collections.emptyList();
    }

    public static boolean isHtmlElementInTableCoordinates(HtmlElement aHtmlElement, List<WPath.TableCoordinate> aTableCoordinates, HtmlPageIndex aHtmlPageIndex, FindSpot aPathSpot) {
        boolean tmpFound = true;
        HtmlElement tmpHtmlElement = aHtmlElement;
        block0: for (WPath.TableCoordinate tmpTableCoordinate : aTableCoordinates) {
            HtmlTable tmpHtmlTable;
            HtmlTableRow tmpHtmlTableRow;
            if (!tmpFound) break;
            tmpFound = false;
            HtmlTableCell tmpCell = ByTableCoordinatesMatcher.findEnclosingCell(tmpHtmlElement);
            if (tmpCell == null) break;
            SearchPattern tmpSearchPatternCoordX = null;
            SearchPattern tmpSearchPatternCoordY = null;
            if (tmpTableCoordinate.getCoordinateX() != null) {
                tmpSearchPatternCoordX = tmpTableCoordinate.getCoordinateX().getSearchPattern();
            }
            if (tmpTableCoordinate.getCoordinateY() != null) {
                tmpSearchPatternCoordY = tmpTableCoordinate.getCoordinateY().getSearchPattern();
            }
            boolean tmpFoundX = false;
            boolean tmpFoundY = false;
            while (tmpCell != null && (tmpHtmlTableRow = tmpCell.getEnclosingRow()) != null && (tmpHtmlTable = tmpHtmlTableRow.getEnclosingTable()) != null) {
                TableMatrix tmpTableMatrix = new TableMatrix(tmpHtmlTable, tmpCell);
                if (!tmpFoundX && tmpSearchPatternCoordX != null) {
                    int tmpXStart = tmpTableMatrix.getAnchorColumn();
                    int tmpXEnd = tmpXStart + tmpCell.getColumnSpan();
                    for (int tmpCol = tmpXStart; tmpCol < tmpXEnd; ++tmpCol) {
                        for (int tmpRow = 0; tmpRow < tmpTableMatrix.getRowCount(); ++tmpRow) {
                            HtmlTableCell tmpOuterCellX = tmpTableMatrix.getCellAt(tmpCol, tmpRow);
                            if (null == tmpOuterCellX) continue;
                            FindSpot tmpOuterCellXSpot = aHtmlPageIndex.getPosition(tmpOuterCellX);
                            if (aPathSpot != null && aPathSpot.getEndPos() >= tmpOuterCellXSpot.getStartPos() || !tmpSearchPatternCoordX.matches(aHtmlPageIndex.getAsText(tmpOuterCellX))) continue;
                            tmpFoundX = true;
                            break;
                        }
                        if (tmpFoundX) break;
                    }
                }
                if (!tmpFoundY && tmpSearchPatternCoordY != null) {
                    int tmpYStart = tmpTableMatrix.getAnchorRow();
                    int tmpYEnd = tmpYStart + tmpCell.getRowSpan();
                    tmpYEnd = Math.min(tmpYEnd, tmpTableMatrix.getRowCount());
                    for (int tmpRow = tmpYStart; tmpRow < tmpYEnd; ++tmpRow) {
                        for (int tmpCol = 0; tmpCol < tmpTableMatrix.getColCount(tmpRow); ++tmpCol) {
                            HtmlTableCell tmpOuterCellY = tmpTableMatrix.getCellAt(tmpCol, tmpRow);
                            if (null == tmpOuterCellY) continue;
                            FindSpot tmpOuterCellYSpot = aHtmlPageIndex.getPosition(tmpOuterCellY);
                            if (aPathSpot != null && aPathSpot.getEndPos() >= tmpOuterCellYSpot.getStartPos() || !tmpSearchPatternCoordY.matches(aHtmlPageIndex.getAsText(tmpOuterCellY))) continue;
                            tmpFoundY = true;
                            break;
                        }
                        if (tmpFoundY) break;
                    }
                }
                if ((tmpFoundX || tmpSearchPatternCoordX == null) && (tmpFoundY || tmpSearchPatternCoordY == null)) {
                    tmpFound = true;
                    tmpHtmlElement = tmpCell.getEnclosingRow();
                    continue block0;
                }
                tmpCell = ByTableCoordinatesMatcher.findEnclosingCell(tmpHtmlTableRow);
            }
        }
        return tmpFound;
    }

    private static HtmlTableCell findEnclosingCell(HtmlElement aHtmlElement) {
        DomNode tmpParent;
        for (tmpParent = aHtmlElement; tmpParent != null && !(tmpParent instanceof HtmlTableCell); tmpParent = tmpParent.getParentNode()) {
        }
        if (tmpParent == null) {
            return null;
        }
        return (HtmlTableCell)tmpParent;
    }

    private static final class TableMatrix {
        private final List<List<HtmlTableCell>> rows = new ArrayList<List<HtmlTableCell>>();
        private int anchorColumn;
        private int anchorRow;

        private TableMatrix(HtmlTable aTable, HtmlTableCell anAnchorCell) {
            HashMap<Long, HtmlTableCell> tmpOccupied = new HashMap<Long, HtmlTableCell>();
            int tmpRow = 0;
            int tmpMaxRow = 0;
            int tmpMaxCol = 0;
            for (HtmlTableRow tmpHtmlTableRow : aTable.getRows()) {
                ArrayList<HtmlTableCell> tmpRowCells = new ArrayList<HtmlTableCell>();
                this.rows.add(tmpRowCells);
                HtmlTableRow.CellIterator tmpCellIterator = tmpHtmlTableRow.getCellIterator();
                int tmpCol = 0;
                for (HtmlTableCell tmpCell : tmpCellIterator) {
                    HtmlTableCell tmpOccupyingCell = (HtmlTableCell)tmpOccupied.get(this.calculateMatrixPos(tmpCol, tmpRow));
                    while (tmpOccupyingCell != null) {
                        tmpRowCells.add(tmpOccupyingCell);
                        tmpOccupyingCell = (HtmlTableCell)tmpOccupied.get(this.calculateMatrixPos(++tmpCol, tmpRow));
                    }
                    tmpRowCells.add(tmpCell);
                    if (tmpCell == anAnchorCell) {
                        this.setAnchorColumn(tmpCol);
                        this.setAnchorRow(tmpRow);
                    }
                    if (tmpCell.getRowSpan() > 1 || tmpCell.getColumnSpan() > 1) {
                        tmpMaxRow = Math.max(tmpMaxRow, tmpRow + tmpCell.getRowSpan());
                        tmpMaxCol = Math.max(tmpMaxCol, tmpCol + tmpCell.getColumnSpan());
                        for (int i = 0; i < tmpCell.getRowSpan(); ++i) {
                            for (int j = 0; j < tmpCell.getColumnSpan(); ++j) {
                                tmpOccupied.put(this.calculateMatrixPos(tmpCol + j, tmpRow + i), tmpCell);
                            }
                        }
                    }
                    tmpMaxCol = Math.max(tmpMaxCol, ++tmpCol);
                }
                while (tmpCol < tmpMaxCol) {
                    tmpRowCells.add((HtmlTableCell)tmpOccupied.get(this.calculateMatrixPos(tmpCol, tmpRow)));
                    ++tmpCol;
                }
                tmpMaxRow = Math.max(tmpMaxRow, ++tmpRow);
            }
            for (int i = 0; i < tmpMaxRow; ++i) {
                ArrayList tmpRowCells = new ArrayList();
                this.rows.add(tmpRowCells);
                for (int j = 0; j < tmpMaxCol; ++j) {
                    tmpRowCells.add(tmpOccupied.get(this.calculateMatrixPos(j, i)));
                }
            }
        }

        private long calculateMatrixPos(int aColumn, int aRow) {
            return (long)aColumn << 32 | (long)aRow & 0xFFFFFFFFL;
        }

        private HtmlTableCell getCellAt(int aCol, int aRow) {
            if (aRow >= this.rows.size()) {
                return null;
            }
            List<HtmlTableCell> tmpRow = this.rows.get(aRow);
            if (aCol >= tmpRow.size()) {
                return null;
            }
            return tmpRow.get(aCol);
        }

        private int getRowCount() {
            return this.rows.size();
        }

        private int getColCount(int aRow) {
            if (aRow >= this.rows.size()) {
                return 0;
            }
            return this.rows.get(aRow).size();
        }

        private int getAnchorColumn() {
            return this.anchorColumn;
        }

        private void setAnchorColumn(int aCol) {
            this.anchorColumn = aCol;
        }

        private int getAnchorRow() {
            return this.anchorRow;
        }

        private void setAnchorRow(int aRow) {
            this.anchorRow = aRow;
        }
    }
}

