/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import org.apache.commons.lang3.StringUtils;
import org.htmlunit.html.HtmlElement;

public final class DescribingTextBuilder {
    private final HtmlElement htmlElement;
    private final StringBuilder describingText = new StringBuilder();

    public static DescribingTextBuilder createDefault(HtmlElement anHtmlElement) {
        return new DescribingTextBuilder(anHtmlElement).addId().addName().addDataTestid();
    }

    public static DescribingTextBuilder createCustom(HtmlElement anHtmlElement) {
        return new DescribingTextBuilder(anHtmlElement);
    }

    private DescribingTextBuilder(HtmlElement anHtmlElement) {
        this.htmlElement = anHtmlElement;
        this.describingText.append('[').append(this.htmlElement.getClass().getSimpleName());
    }

    public DescribingTextBuilder addId() {
        return this.addAttribute("id", this.htmlElement.getAttribute("id"));
    }

    public DescribingTextBuilder addDataTestid() {
        return this.addAttribute("data-testid", this.htmlElement.getAttribute("data-testid"));
    }

    public DescribingTextBuilder addName() {
        return this.addAttribute("name", this.htmlElement.getAttribute("name"));
    }

    public DescribingTextBuilder addAttribute(String aName, String aValue) {
        if (StringUtils.isNotBlank(aName) && StringUtils.isNotEmpty(aValue)) {
            this.describingText.append(" (").append(aName).append("='").append(aValue).append("')");
        }
        return this;
    }

    public DescribingTextBuilder addText(String aText) {
        this.describingText.append(" '").append(aText).append('\'');
        return this;
    }

    public DescribingTextBuilder addPlain(String aText) {
        if (StringUtils.isNotBlank(aText)) {
            this.describingText.append(' ').append(aText);
        }
        return this;
    }

    public String build() {
        return this.describingText.append(']').toString();
    }
}

