/*
 * Decompiled with CFR 0.152.
 */
package org.wetator.backend.htmlunit.util;

import org.apache.commons.lang3.StringUtils;
import org.htmlunit.SgmlPage;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlButtonInput;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlEmailInput;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlLabel;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlNumberInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlOptionGroup;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlParagraph;
import org.htmlunit.html.HtmlPasswordInput;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlResetInput;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlSpan;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlTelInput;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.HtmlTextInput;
import org.htmlunit.html.HtmlUrlInput;
import org.wetator.backend.htmlunit.util.DescribingTextBuilder;

public final class HtmlElementUtil {
    private HtmlElementUtil() {
    }

    public static String getDescribingTextForHtmlAnchor(HtmlAnchor anHtmlAnchor) {
        String tmpText;
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom(anHtmlAnchor);
        if (anHtmlAnchor.getFirstChild() instanceof HtmlImage) {
            tmpBuilder.addPlain("'image: " + ((HtmlImage)anHtmlAnchor.getFirstChild()).getSrcAttribute() + "'");
        }
        if (StringUtils.isNotEmpty(tmpText = anHtmlAnchor.asNormalizedText())) {
            tmpBuilder.addText(tmpText);
        }
        return tmpBuilder.addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlBody(HtmlBody anHtmlBody) {
        return DescribingTextBuilder.createDefault(anHtmlBody).build();
    }

    public static String getDescribingTextForHtmlButton(HtmlButton anHtmlButton) {
        String tmpText;
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom(anHtmlButton);
        if (anHtmlButton.getFirstChild() instanceof HtmlImage) {
            tmpBuilder.addPlain("'image: " + ((HtmlImage)anHtmlButton.getFirstChild()).getSrcAttribute() + "'");
        }
        if (StringUtils.isNotEmpty(tmpText = anHtmlButton.asNormalizedText())) {
            tmpBuilder.addText(tmpText);
        } else if (StringUtils.isNotEmpty(anHtmlButton.getValueAttribute())) {
            tmpBuilder.addText(anHtmlButton.getValueAttribute());
        }
        return tmpBuilder.addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlButtonInput(HtmlButtonInput anHtmlButtonInput) {
        return DescribingTextBuilder.createCustom(anHtmlButtonInput).addText(anHtmlButtonInput.getValue()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlCheckBoxInput(HtmlCheckBoxInput anHtmlCheckBoxInput) {
        return DescribingTextBuilder.createDefault(anHtmlCheckBoxInput).build();
    }

    public static String getDescribingTextForHtmlFileInput(HtmlFileInput anHtmlFileInput) {
        return DescribingTextBuilder.createDefault(anHtmlFileInput).build();
    }

    public static String getDescribingTextForHtmlHiddenInput(HtmlHiddenInput anHtmlHiddenInput) {
        return DescribingTextBuilder.createDefault(anHtmlHiddenInput).build();
    }

    public static String getDescribingTextForHtmlImage(HtmlImage anHtmlImage) {
        return DescribingTextBuilder.createCustom(anHtmlImage).addText(anHtmlImage.getSrcAttribute()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlImageInput(HtmlImageInput anHtmlImageInput) {
        return DescribingTextBuilder.createCustom(anHtmlImageInput).addText(anHtmlImageInput.getValue()).addAttribute("src", anHtmlImageInput.getSrcAttribute()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlLabel(HtmlLabel anHtmlLabel) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom(anHtmlLabel);
        String tmpText = anHtmlLabel.asNormalizedText();
        if (StringUtils.isNotEmpty(tmpText)) {
            tmpBuilder.addText(tmpText);
        }
        tmpBuilder.addId().addName().addDataTestid();
        String tmpFor = anHtmlLabel.getForAttribute();
        if (StringUtils.isNotEmpty(tmpFor)) {
            tmpBuilder.addAttribute("for", tmpFor);
        }
        return tmpBuilder.build();
    }

    public static String getDescribingTextForHtmlParagraph(HtmlParagraph anHtmlParagraph) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom(anHtmlParagraph);
        String tmpText = anHtmlParagraph.asNormalizedText();
        if (StringUtils.isNotEmpty(tmpText)) {
            tmpBuilder.addText(tmpText);
        }
        return tmpBuilder.addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlPasswordInput(HtmlPasswordInput anHtmlPasswordInput) {
        return DescribingTextBuilder.createDefault(anHtmlPasswordInput).build();
    }

    public static String getDescribingTextForHtmlRadioButtonInput(HtmlRadioButtonInput anHtmlRadioButtonInput) {
        return DescribingTextBuilder.createCustom(anHtmlRadioButtonInput).addText(anHtmlRadioButtonInput.getValue()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlResetInput(HtmlResetInput anHtmlResetInput) {
        return DescribingTextBuilder.createCustom(anHtmlResetInput).addText(anHtmlResetInput.getValue()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlSelect(HtmlSelect anHtmlSelect) {
        return DescribingTextBuilder.createDefault(anHtmlSelect).build();
    }

    public static String getDescribingTextForHtmlSpan(HtmlSpan anHtmlSpan) {
        return DescribingTextBuilder.createCustom(anHtmlSpan).addText(anHtmlSpan.asNormalizedText()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlSubmitInput(HtmlSubmitInput anHtmlSubmitInput) {
        return DescribingTextBuilder.createCustom(anHtmlSubmitInput).addText(anHtmlSubmitInput.getValue()).addId().addName().addDataTestid().build();
    }

    public static String getDescribingTextForHtmlTextArea(HtmlTextArea anHtmlTextArea) {
        return DescribingTextBuilder.createDefault(anHtmlTextArea).build();
    }

    public static String getDescribingTextForHtmlEmailInput(HtmlEmailInput anHtmlEmailInput) {
        return DescribingTextBuilder.createDefault(anHtmlEmailInput).build();
    }

    public static String getDescribingTextForHtmlNumberInput(HtmlNumberInput anHtmlNumberInput) {
        return DescribingTextBuilder.createDefault(anHtmlNumberInput).build();
    }

    public static String getDescribingTextForHtmlTelInput(HtmlTelInput anHtmlTelInput) {
        return DescribingTextBuilder.createDefault(anHtmlTelInput).build();
    }

    public static String getDescribingTextForHtmlUrlInput(HtmlUrlInput anHtmlUrlInput) {
        return DescribingTextBuilder.createDefault(anHtmlUrlInput).build();
    }

    public static String getDescribingTextForHtmlTextInput(HtmlTextInput anHtmlTextInput) {
        return DescribingTextBuilder.createDefault(anHtmlTextInput).build();
    }

    public static String getDescribingTextForHtmlOption(HtmlOption anHtmlOption) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom(anHtmlOption).addText(anHtmlOption.asNormalizedText()).addId().addName().addDataTestid();
        HtmlSelect tmpSelect = anHtmlOption.getEnclosingSelect();
        if (null != tmpSelect) {
            tmpBuilder.addPlain("part of " + HtmlElementUtil.getDescribingTextForHtmlSelect(tmpSelect));
        }
        return tmpBuilder.build();
    }

    public static String getDescribingTextForHtmlOptionGroup(HtmlOptionGroup anHtmlOptionGroup) {
        DescribingTextBuilder tmpBuilder = DescribingTextBuilder.createCustom(anHtmlOptionGroup).addText(anHtmlOptionGroup.getLabelAttribute()).addId().addName().addDataTestid();
        HtmlSelect tmpSelect = anHtmlOptionGroup.getEnclosingSelect();
        if (null != tmpSelect) {
            tmpBuilder.addPlain("part of " + HtmlElementUtil.getDescribingTextForHtmlSelect(tmpSelect));
        }
        return tmpBuilder.build();
    }

    public static boolean isBlock(DomNode aDomNode) {
        SgmlPage tmpPage = aDomNode.getPage();
        if (tmpPage instanceof HtmlPage && tmpPage.getEnclosingWindow().getWebClient().getOptions().isCssEnabled() && aDomNode instanceof HtmlElement) {
            HtmlElement tmpElement = (HtmlElement)aDomNode;
            if (tmpElement instanceof HtmlLink) {
                return true;
            }
            if (tmpElement instanceof HtmlOption) {
                return true;
            }
            ComputedCssStyleDeclaration tmpStyle = tmpPage.getEnclosingWindow().getComputedStyle(tmpElement, null);
            if (tmpStyle != null) {
                String tmpDisplay = tmpStyle.getDisplay();
                if ("block".equals(tmpDisplay) || "inline-block".equals(tmpDisplay) || "list-item".equals(tmpDisplay) || "flex".equals(tmpDisplay)) {
                    return true;
                }
                if (tmpDisplay != null && (tmpDisplay.startsWith("table") || "inline-table".equals(tmpDisplay))) {
                    return true;
                }
            }
        }
        return false;
    }
}

